DELIMITER $$
DROP PROCEDURE IF EXISTS V202001201714__AlterBFPRS $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001201714__AlterBFPRS()

BEGIN
  
  -- Add the email_address column to the email table, if it doesn't already exist
  
 IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='bill_fee_plan_rule_stage' 
  AND column_name='orgCurrConcessionAmount')) THEN
	ALTER TABLE `bill_fee_plan_rule_stage` 
ADD COLUMN `orgCurrConcessionAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `orgCurrCovertedbalanceAmount`,
ADD INDEX `fk_bill_fee_plan_rule_stage_AcademyLocationCurrency_idx` (`acadLocCurrencyConvertionId` ASC),
ADD INDEX `fk_bill_fee_plan_rule_stage_organizationCurrency_idx` (`orgCurrencyConvertionId` ASC);
ALTER TABLE `bill_fee_plan_rule_stage` 
ADD CONSTRAINT `fk_bill_fee_plan_rule_stage_AcademyLocationCurrency`
  FOREIGN KEY (`acadLocCurrencyConvertionId`)
  REFERENCES `currency_exchange_history` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_bill_fee_plan_rule_stage_organizationCurrency`
  FOREIGN KEY (`orgCurrencyConvertionId`)
  REFERENCES `currency_exchange_history` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  END IF;

END $$

-- Execute the stored procedure
CALL V202001201714__AlterBFPRS() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001201714__AlterBFPRS $$
 
DELIMITER ;