DELIMITER $$

DROP PROCEDURE IF EXISTS V202001291848__AlterReceiptHeader $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V202001291848__AlterReceiptHeader()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='receipt_header')) THEN
  
	ALTER TABLE `receipt_header` 
		ADD COLUMN `acadLocCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `cancellationDate`,
		ADD COLUMN `orgCurrencyConversionId` BIGINT(20) NULL DEFAULT NULL AFTER `acadLocCurrencyConversionId`,
		ADD COLUMN `acadLocCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `orgCurrencyConversionId`,
		ADD COLUMN `orgCurrConvertedAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `acadLocCurrConvertedAmount`,
		ADD COLUMN `acadLocCurrencyId` BIGINT(20) NULL DEFAULT NULL AFTER `orgCurrConvertedAmount`,
		ADD COLUMN `orgCurrencyId` BIGINT(20) NULL AFTER `acadLocCurrencyId`,
		ADD INDEX `fk_receipt_header_academyLocationCurrency_idx` (`acadLocCurrencyConversionId` ASC),
		ADD INDEX `fk_receipt_header_acade_loc_currency_to_currency_idx` (`acadLocCurrencyId` ASC),
		ADD INDEX `fk_receipt_header_org_currency_to_currency_idx` (`orgCurrencyId` ASC),
		ADD INDEX `fk_receipt_header_organizationCurrency_idx` (`orgCurrencyConversionId` ASC);
		
		ALTER TABLE `receipt_header` 
		ADD CONSTRAINT `fk_receipt_header_academyLocationCurrency`
		  FOREIGN KEY (`acadLocCurrencyConversionId`)
		  REFERENCES `currency_exchange_history` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT,
		ADD CONSTRAINT `fk_receipt_header_acad_loc_currency_to_currency`
		  FOREIGN KEY (`acadLocCurrencyId`)
		  REFERENCES `currency` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT,
		ADD CONSTRAINT `fk_receipt_header_org_currency_to_currency`
		  FOREIGN KEY (`orgCurrencyId`)
		  REFERENCES `currency` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT,
		ADD CONSTRAINT `fk_receipt_header_organizationCurrency`
		  FOREIGN KEY (`orgCurrencyConversionId`)
		  REFERENCES `currency_exchange_history` (`id`)
		  ON DELETE RESTRICT
		  ON UPDATE RESTRICT;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V202001291848__AlterReceiptHeader() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V202001291848__AlterReceiptHeader $$
 
DELIMITER ;