DELIMITER $$

DROP PROCEDURE IF EXISTS V202002031817__Update_ReferencesDFR $$

CREATE PROCEDURE V202002031817__Update_ReferencesDFR()

BEGIN
	
  IF EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationreferenceform' and  formFieldName ='referenceName')) THEN
    
  	SET SQL_SAFE_UPDATES = 0;
  	
	UPDATE `form_field_info` SET `lastUpdatedBy`=1,`lastUpdate`=now(),`formFieldDefaultLabel`='Full Name',`fieldDisplayName`='Full Name',`isLocked`=1
	WHERE formAliasName = 'applicationreferenceform' and  formFieldName ='referenceName';

	SET SQL_SAFE_UPDATES = 1;
	
  END IF;
  
  IF EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationreferenceform' and  formFieldName ='designation')) THEN
    
  	SET SQL_SAFE_UPDATES = 0;
  	
	UPDATE `form_field_info` SET `lastUpdatedBy`=1,`lastUpdate`=now(),`isMandatory`=0
	WHERE formAliasName = 'applicationreferenceform' and  formFieldName ='designation';

	SET SQL_SAFE_UPDATES = 1;
	
  END IF;
  
  IF EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'applicationreferenceform' and  formFieldName ='remark')) THEN
    
  	SET SQL_SAFE_UPDATES = 0;
  	
	UPDATE `form_field_info` SET `lastUpdatedBy`=1,`lastUpdate`=now(),`formFieldInputType`='textfield',`formFieldDefaultLabel`='Remark',`fieldDisplayName`='Remark'
	WHERE formAliasName = 'applicationreferenceform' and  formFieldName ='remark';

	SET SQL_SAFE_UPDATES = 1;
	
  END IF;
  
END $$
  
CALL V202002031817__Update_ReferencesDFR() $$

DROP PROCEDURE IF EXISTS V202002031817__Update_ReferencesDFR $$
 
DELIMITER ;