DELIMITER $$
DROP PROCEDURE IF EXISTS V20200208113901__Create_data_grid_user_override $$
CREATE PROCEDURE V20200208113901__Create_data_grid_user_override()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='data_grid_user_override' )) THEN 
CREATE TABLE `data_grid_user_override` (
 `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
 `dataGridId` BIGINT(20) NOT NULL,
 `userId` BIGINT(20) NULL DEFAULT NULL,
 `applicantId` BIGINT(20) NULL DEFAULT NULL,
 `jsonObject` TEXT NOT NULL,
 `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
 `lastUpdatedBy` BIGINT(20) NULL DEFAULT NULL,
 PRIMARY KEY (`id`),
 INDEX `RefDataGrid2607_idx` (`dataGridId` ASC),
 INDEX `Refuser2607_idx` (`userId` ASC),
 INDEX `refuserlastupdate2607_idx` (`lastUpdatedBy` ASC),
 INDEX `refapplicantId2607_idx` (`applicantId` ASC),
 CONSTRAINT `Refdatagrid2607`
   FOREIGN KEY (`dataGridId`)
   REFERENCES `data_grid` (`id`)
   ON DELETE NO ACTION
   ON UPDATE NO ACTION,
 CONSTRAINT `Refuser2607`
   FOREIGN KEY (`userId`)
   REFERENCES `users` (`id`)
   ON DELETE NO ACTION
   ON UPDATE NO ACTION,
 CONSTRAINT `refuserlastupdate2607`
   FOREIGN KEY (`lastUpdatedBy`)
   REFERENCES `users` (`id`)
   ON DELETE NO ACTION
   ON UPDATE NO ACTION,
 CONSTRAINT `refapplicantId2607`
   FOREIGN KEY (`applicantId`)
   REFERENCES `application` (`id`)
   ON DELETE NO ACTION
   ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200208113901__Create_data_grid_user_override () $$ 
DROP PROCEDURE IF EXISTS V20200208113901__Create_data_grid_user_override $$ 
DELIMITER ;