DELIMITER $$
DROP PROCEDURE IF EXISTS V20200323155954__Alter_galleryBatchMapping $$
CREATE PROCEDURE V20200323155954__Alter_galleryBatchMapping()
BEGIN
IF EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='gallery_batch_mapping')) THEN 

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='gallery_batch_mapping' AND column_name='academyLocationId')) THEN 
ALTER TABLE `gallery_batch_mapping` 
ADD COLUMN `academyLocationId` BIGINT(20) NULL AFTER `lastUpdate`,
ADD INDEX `fk_gallery_batch_mapping_academyLocation_idx` (`academyLocationId` ASC),
ADD CONSTRAINT `fk_gallery_batch_mapping_academyLocation`
  FOREIGN KEY (`academyLocationId`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF; 
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='gallery_batch_mapping' AND column_name='programId')) THEN 

ALTER TABLE `gallery_batch_mapping`
ADD COLUMN `programId` BIGINT(20) NULL AFTER `academyLocationId`,
ADD INDEX `fk_gallery_batch_mapping_program_idx` (`programId` ASC),
ADD CONSTRAINT `fk_gallery_batch_mapping_program`
  FOREIGN KEY (`programId`)
  REFERENCES `programs` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

END IF; 
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='gallery_batch_mapping' AND column_name='sectionId')) THEN 
ALTER TABLE `gallery_batch_mapping`
ADD COLUMN `sectionId` BIGINT(20) NULL AFTER `programId`,
ADD INDEX `fk_gallery_batch_mapping_sections_idx` (`sectionId` ASC),
ADD CONSTRAINT `fk_gallery_batch_mapping_sections`
  FOREIGN KEY (`sectionId`)
  REFERENCES `sections` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

END IF; 
IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='gallery_batch_mapping' AND column_name='isSharedWithParent')) THEN 
ALTER TABLE `gallery_batch_mapping`
ADD COLUMN `isSharedWithParent` BIT(1) NULL AFTER `sectionId`;


END IF; 
END IF; 
END $$
CALL V20200323155954__Alter_galleryBatchMapping() $$
DROP PROCEDURE IF EXISTS V20200323155954__Alter_galleryBatchMapping $$
DELIMITER ;