DELIMITER $$
DROP PROCEDURE IF EXISTS V20200325152255__Create_ID_Type_Master $$
CREATE PROCEDURE V20200325152255__Create_ID_Type_Master()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='id_type' )) THEN 
CREATE TABLE `id_type`(
		  `id` bigint(20) NOT NULL AUTO_INCREMENT,
		  `idTypeCode` varchar(255) NOT NULL,
		  `idTypeName` varchar(255) NOT NULL,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`),
		  KEY `fk_idtype_updateby` (`lastUpdatedBy`),
		  CONSTRAINT `fk_idtype_updateby` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) 
			  ON DELETE NO ACTION 
			  ON UPDATE NO ACTION
		)ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM standard_master WHERE tableName = 'id_type')) THEN

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'id_type','ID_TYPE','Admissions','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'idTypeCode', 'IDTYPE_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'idTypeName', 'IDTYPE_NAME', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());

END IF;

END $$
CALL V20200325152255__Create_ID_Type_Master () $$ 
DROP PROCEDURE IF EXISTS V20200325152255__Create_ID_Type_Master $$ 
DELIMITER ;