DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402151120__Create_users_system_usage_log_view $$
CREATE PROCEDURE V20200402151120__Create_users_system_usage_log_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'users_system_usage_log_view')) THEN 
DROP view `users_system_usage_log_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'users_system_usage_log_view')) THEN 
CREATE OR REPLACE VIEW `users_system_usage_log_view` AS
SELECT
    u.code,
    u.printName AS 'User',
    sm1.moduleName AS 'Module Name',
    f.featureName AS 'Link name',
    p.privilegeName AS 'Privilege Name',
    al.academyName AS 'Academy Name',
    al.id AS 'Academy Location Id',
    al.locationName AS Location,
    ug.userGroupName AS 'User Group',
    CASE
        WHEN u.status = 1 THEN 'Active'
        ELSE 'Inactive'
    END AS Status,
    DATE_FORMAT(usul.accessTime, '%d/%m/%Y') AS 'Access Date',
    CAST(usul.accessTime AS TIME) 'Access Time'
FROM
    users_system_usage_log usul
        LEFT JOIN
    users u ON u.id = usul.userId
        LEFT JOIN
    user_groups ug ON ug.id = u.userGroupId
        JOIN
    user_academy_locations ual ON ual.userId = u.id
    and ual.academyLocationId=usul.academyLocationId
        JOIN
    academy_location al ON al.id = ual.academyLocationId
        LEFT JOIN
    feature_privilege fp ON fp.id = usul.featurePrivilegeId
        LEFT JOIN
    privilege p ON p.id = fp.privilegeId
        LEFT JOIN
    feature f ON f.id = fp.featureId
        LEFT JOIN
    system_modules sm ON sm.id = f.systemModuleId
        LEFT JOIN
    system_modules sm1 ON sm.parentId = sm1.id;
END IF; 

END $$
CALL V20200402151120__Create_users_system_usage_log_view () $$ 
DROP PROCEDURE IF EXISTS V20200402151120__Create_users_system_usage_log_view $$ 
DELIMITER ;