DELIMITER $$
DROP PROCEDURE IF EXISTS V20200402162943__Create_grade_wise_report_view $$
CREATE PROCEDURE V20200402162943__Create_grade_wise_report_view()
BEGIN

IF  EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'grade_wise_report_view')) THEN 
DROP view `grade_wise_report_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'grade_wise_report_view')) THEN 
CREATE or REPLACE VIEW `grade_wise_report_view` AS  
select distinct
        `al`.`academyName` AS `Brand`,
        `al`.`locationName` AS `Campus`,
        `al`.`displayName` AS `Brand Campus`,
        `al`.`id` AS `Academy Location Id`,
        `pg`.`groupName` AS `School Phase`,
        `prgm`.`programNameToBePrint` AS `Grade`,
        `pc`.`categoryName` AS `Grade Category`,
        `batch`.`printName` AS `Intake`,
        `period`.`printName` AS `Period`,
        `section`.`sectionCode` AS `Class`,
        `fac`.`printName` AS `Class Teacher`,
        `usr`.`printName` AS `Student Name`,
        `usr`.`code` AS `Student Id`,
        `periodRank`.`obtainedMarks` AS `Period Level Marks`,
        `periodRank`.`sgpa` AS `SGPA`,
        `prgmRank`.`effectiveMarks` AS `Program Level Marks`,
        `prgmRank`.`obtainedCreditSum` AS `Credits Earned`,
        `prgmRank`.`CGPA` AS `CGPA`,
        `levelOne`.`levelName` AS `Type Name`,
        `levelTwo`.`levelName` AS `SubType Name`,
        `prgmRank`.`percentage` AS `percentage`,
        `avrg`.`marks` AS `Student Average`,
        `prgmRank`.`sectionRank` AS `Class Rank`,
        `prgmRank`.`programRank` AS `Grade Rank`,
        `prgmRank`.`status` AS `Result Status`,
        `pbs`.`endorsmentCertificateName` AS `Certificate`
    from
        ((((((((((((((((`evaluation_period_rank` `periodRank`
        join `admission` ON ((`admission`.`id` = `periodRank`.`admissionId`)))
        join `users` `usr` ON ((`usr`.`id` = `admission`.`studentId`)))
        join `academy_location` `al` ON ((`al`.`id` = `admission`.`academyLocationId`)))
        join `prog_batch_period_config` `period` ON ((`period`.`id` = `periodRank`.`periodId`)))
        join `batches` `batch` ON ((`batch`.`id` = `period`.`programBatchId`)))
        join `programs` `prgm` ON ((`prgm`.`id` = `batch`.`programId`)))
        join `evaluation_program_rank` `prgmRank` ON (((`prgmRank`.`batchId` = `batch`.`id`)
            and (`periodRank`.`admissionId` = `prgmRank`.`admissionId`))))
        left join `program_group` `pg` ON ((`pg`.`id` = `prgm`.`programGroupId`)))
        left join `program_category` `pc` ON ((`pc`.`id` = `prgm`.`programCategoryId`)))
        left join `exam_student_average` `avrg` ON (((`avrg`.`admissionId` = `admission`.`id`)
            and (`avrg`.`periodId` = `period`.`id`))))
        join `exam_student_average_detail` `avrgDetail` ON (((`avrgDetail`.`examStudentAverageId` = `avrg`.`id`)
            and isnull(`avrgDetail`.`methodId`))))
        left join `evaluation_plan_level_one` `levelOne` ON ((`levelOne`.`id` = `avrgDetail`.`typeId`)))
        left join `evaluation_plan_level_two` `levelTwo` ON ((`levelTwo`.`id` = `avrgDetail`.`subTypeId`)))
        left join `program_batch_students` `pbs` ON (((`pbs`.`admissionId` = `periodRank`.`admissionId`)
            and (`pbs`.`programBatchId` = `prgmRank`.`batchId`)
            and (`pbs`.`sectionId` is not null)
            and (`pbs`.`isCurrentPeriod` = 1)
            and (`pbs`.`isCurrentSection` = 1))))
        left join `sections` `section` ON ((`pbs`.`sectionId` = `section`.`id`)))
        left join `users` `fac` ON ((`fac`.`id` = `section`.`facultyId`)));
END IF; 

END $$
CALL V20200402162943__Create_grade_wise_report_view () $$ 
DROP PROCEDURE IF EXISTS V20200402162943__Create_grade_wise_report_view $$ 
DELIMITER ;