DELIMITER $$
DROP PROCEDURE IF EXISTS V20200505131005__Update_UI_IntoStandardMasterItemOBEZurich $$
CREATE PROCEDURE V20200505131005__Update_UI_IntoStandardMasterItemOBEZurich()
BEGIN

	SET SQL_SAFE_UPDATES=0;

	SET @standardMasterMaxId=(SELECT id FROM standard_master where tableName='obe_correlation_level');

	IF EXISTS ((select * from standard_master_items where standardMasterId=@standardMasterMaxId and dbFieldName='levelDescription')) THEN 
		UPDATE `standard_master_items` 
		SET  `dbFieldName` = 'levelPercentage',`fieldLabel` = 'CORRELATION_LEVEL_PERCENTAGE',`fieldType` = 'Number'
		WHERE dbFieldName = 'levelDescription' AND standardMasterId = @standardMasterMaxId;
	END IF; 
	
	IF EXISTS ((select * from standard_master_items where standardMasterId=@standardMasterMaxId and dbFieldName='levelValue')) THEN 
		DELETE FROM `standard_master_items` WHERE dbFieldName = 'levelValue' AND standardMasterId = @standardMasterMaxId;
	END IF; 
	
	SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200505131005__Update_UI_IntoStandardMasterItemOBEZurich () $$
DROP PROCEDURE IF EXISTS V20200505131005__Update_UI_IntoStandardMasterItemOBEZurich $$
DELIMITER ;