DELIMITER $$
DROP PROCEDURE IF EXISTS V20200602132656__Create_CGPAReportTemplate $$
CREATE PROCEDURE V20200602132656__Create_CGPAReportTemplate()
BEGIN


IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'CGPA_ANALYSIS_REPORT' )) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'CGPA_ANALYSIS_REPORT', 'CGPA Analysis Report', 'CGPA_ANALYSIS_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'CGPA_Header_Excel_Blank.jasper', 'Footer_Excel_Blank.jasper', '1', '1', 'CGPA_ANALYSIS_REPORT.jasper', 'AcademiaLogo.png'); 


set @cgpaAnalysis = (select max(id) from report_template where templateCode ='CGPA_ANALYSIS_REPORT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@cgpaAnalysis, 'TRANS_REPORT_NAME', 'CGPA Analysis Report', '1', NOW()),
(@cgpaAnalysis, 'TRANS_ACADEMIC_TERM', 'Academic Term', '1', NOW()),
(@cgpaAnalysis, 'TRANS_SNO', 'S.No.', '1', NOW()),
(@cgpaAnalysis, 'TRANS_ACADEMY_LOCATION', 'Academy Location Name', '1', NOW()),
(@cgpaAnalysis, 'TRANS_PROGRAM_NAME', 'Program Name', '1', NOW()),
(@cgpaAnalysis, 'TRANS_BATCH_NAME', 'Batch Name', '1', NOW()),
(@cgpaAnalysis, 'TRANS_PERIOD_NAME', 'Period', '1', NOW()),
(@cgpaAnalysis, 'TRANS_ASSESSMENT_GROUP_NAME', 'Assessment Group Name', '1', NOW()),
(@cgpaAnalysis, 'TRANS_NUMBER_OF_STUDENT_APPEARED', 'Number of Students Appeared', '1', NOW()),
(@cgpaAnalysis, 'TRANS_CGPA_RANGE', 'CGPA Range', '1', NOW()),
(@cgpaAnalysis, 'TRANS_NUMBER_OF_STUDENT', 'Number of students', '1', NOW()),
(@cgpaAnalysis, 'TRANS_PERCENTAGE', 'Percentage', '1', NOW()); 
END IF; 

END $$
CALL V20200602132656__Create_CGPAReportTemplate () $$ 
DROP PROCEDURE IF EXISTS V20200602132656__Create_CGPAReportTemplate $$ 
DELIMITER ;
