DELIMITER $$
DROP PROCEDURE IF EXISTS V20200604172752__Insert_addReportTemplate $$
CREATE PROCEDURE V20200604172752__Insert_addReportTemplate()
BEGIN

IF NOT EXISTS (SELECT * FROM `report_template` WHERE `templateCode`='ASSESSMENT_SCHEME_DETAIL_REPORT') THEN 
set @reportTypeId = (select id from report_type where typeName='Assessment Scheme Reports');

INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES (@reportTypeId, 'ASSESSMENT_SCHEME_DETAIL_REPORT', 'Assessment Scheme Detail Report', 'ASSESSMENT_SCHEME_DETAIL_REPORT.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'ASSESSMENT_SCHEME_DETAIL_REPORT.jasper', 'AcademiaLogo.png');

set @reportTempId = (select id from report_template where templateCode='ASSESSMENT_SCHEME_DETAIL_REPORT');
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`)
VALUES (@reportTempId, 'TRANS_SCHEME', 'Scheme Name:', Now()),
(@reportTempId, 'TRANS_TYPE', 'Assessment Type', Now()),
(@reportTempId, 'TRANS_SUB_TYPE', 'Assessment Sub Type', Now()),
(@reportTempId, 'TRANS_METHOD', 'Assessment Method', Now()),
(@reportTempId, 'TRANS_EVENT', 'Assessment Event', Now()),
(@reportTempId, 'TRANS_WEIGHTAGE', 'Weightage', Now()),
(@reportTempId, 'TRANS_MARKS_GRADE', 'Marks/Grade', Now()),
(@reportTempId, 'TRANS_GRADE_TYPE', 'Grade Type', Now()),
(@reportTempId, 'TRANS_MIN_PASS', 'Minimum Passing Marks/Grades', Now()),
(@reportTempId, 'TRANS_MAX_OUTOF', 'Maximum Out of Marks/Grades', Now()),
(@reportTempId, 'TRANS_REMARK', 'Whether Remark', Now()),
(@reportTempId, 'TRANS_WPC', 'Whether Passing Critical', Now()),
(@reportTempId, 'TRANS_FAIL_MARKS', 'Fail Marks/Grade to be Awarded', Now()),
(@reportTempId, 'TRANS_REPETITION', 'Repetition Type', Now()),
(@reportTempId, 'TRANS_REPEATED_EVENT', 'Event to be Repeated', Now()),
(@reportTempId, 'TRANS_ASSESSMENT_GROUP', 'Part of Assessment Group', Now()),
(@reportTempId, 'TRANS_ASSIGNMENT', 'Assignment Evaluation', Now()),
(@reportTempId, 'TRANS_DETENTION', 'Contribute to Detention', Now()),
(@reportTempId, 'TRANS_ANONYMOUS', 'Anonymous Assessment', Now()),
(@reportTempId, 'TRANS_ATTENDANCE_BASE', 'Attendance Based Detention', Now()),
(@reportTempId, 'TRANS_ASSESSMENT_BASE', 'Assessment Based Detention', Now()),
(@reportTempId, 'TRANS_ENROLLMENT', 'Auto Enrollment of Students', Now()),
(@reportTempId, 'TRANS_REVALUATION', 'Is Revaluation Possible', Now()),
(@reportTempId, 'TRANS_ADMINISTRATION_MODE', 'Mode of Administration', Now()),
(@reportTempId, 'TRANS_TEST_ADMINISTRATION', 'Test Administrator Mode', Now());

END IF; 

END $$
CALL V20200604172752__Insert_addReportTemplate() $$
DROP PROCEDURE IF EXISTS V20200604172752__Insert_addReportTemplate $$
DELIMITER ;