DELIMITER $$
DROP PROCEDURE IF EXISTS V20200615152625__Create_TableForPeriodYearCSM $$
CREATE PROCEDURE V20200615152625__Create_TableForPeriodYearCSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='period_year')) THEN 
CREATE TABLE `period_year` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `itemCode` varchar(100) NOT NULL,
  `itemValue` varchar(100) NOT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `period_year_UNIQUE` (`itemValue` ASC)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
END IF; 




IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='standard_master')) THEN 
SET @smId=(SELECT id FROM standard_master WHERE tableName LIKE 'period_year%' LIMIT 1);
DELETE FROM standard_master_items 
WHERE
    standardMasterId IN (@smId);
DELETE FROM standard_master 
WHERE
    id IN (@smId);


INSERT INTO `standard_master` (`tableName`, `masterName`, `moduleName`, `filterCode`, `whetherChild`, `whetherParent`, `displayValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('period_year', 'PERIOD_YEAR', 'Program & Courses', 'COMMON_MASTER', 0, 0, 'Period Year', '1', SYSDATE());

SET @standardMasterMaxId=(SELECT id FROM standard_master  WHERE tableName LIKE 'period_year%' LIMIT 1);

INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) VALUES ('masterNames','PERIOD_YEAR','Period Year','Period Year',now(),1);

END IF; 

IF EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='standard_master_items')) THEN 

INSERT INTO standard_master_items( `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
 VALUES ('itemCode', 'ITEM_CODE', @standardMasterMaxId , 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());

INSERT INTO `standard_master_items` (`dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES ('itemValue', 'ITEM_VALUE', @standardMasterMaxId, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());
END IF; 

END $$
CALL V20200615152625__Create_TableForPeriodYearCSM () $$ 
DROP PROCEDURE IF EXISTS V20200615152625__Create_TableForPeriodYearCSM $$ 
DELIMITER ;
