DELIMITER $$
DROP PROCEDURE IF EXISTS V20200618102825__Insert_SNJB_studentReceiptPortal $$
CREATE PROCEDURE V20200618102825__Insert_SNJB_studentReceiptPortal()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '4' AND templateCode = 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE' AND templateName='SNJB receipt - student portal')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('4', 'MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE', 'SNJB receipt - student portal', 'SettlementTriplicateCollege.png', 'CommonReport_LandScape_pageNo_LeftCenterRight.jasper', 'All', '0', 'HeaderBlank_LandScape.jasper', 'FooterBlank.jasper', '0', '0', 'SNJB _StudentReceiptPortal.jasper', 'AcademiaLogo.png');

set @d1SNJBReceiptSettleStudentPortal = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_STUDENT_CODE');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@d1SNJBReceiptSettleStudentPortal , 'TRANS_RECEIPTNO', 'Receipt No.', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_BATCH', 'Batch', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_DATE', 'Date', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_NAME', 'Name', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_FATHER_NAME', 'Father Name', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_COURSE', 'Course', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_ADMISSION_NO', 'Admission No', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_ADMISSION_MODE', 'Admission Mode', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_ACADEMIC_YEAR', 'Academic Year/Sem', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_SR_NO', 'S.No.', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_ACCOUNT_HEAD', 'Account Head', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_AMOUNT', 'Amount', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_TOTAL_DUE_AMOUNT', 'Total Due Amount', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_TOTAL_IN_WORDS', 'Total In Words', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_CURRENCY', 'Currency', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_INSTRUMENT_NO', 'Instrument Number', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_INSTRUMENT_DATE', 'Instrument Date', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_PARENT_PHONE_NO', 'Parent Phone No', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_PARTICULAR', 'Particulars', '1', NOW()),
(@d1SNJBReceiptSettleStudentPortal , 'TRANS_BANK_NAME', 'Instrument Bank Name', '1', NOW());




END IF; 

END $$
CALL V20200618102825__Insert_SNJB_studentReceiptPortal() $$
DROP PROCEDURE IF EXISTS V20200618102825__Insert_SNJB_studentReceiptPortal $$
DELIMITER ;