DELIMITER $$

DROP PROCEDURE IF EXISTS V20200610152025__Insert_UITrsForPortalNew $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20200610152025__Insert_UITrsForPortalNew()

BEGIN
  
   -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='ARE_YOU_REFUGEE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','ARE_YOU_REFUGEE','Are you a refugee?','Are you a refugee?',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='CONTACT_LANGUAGE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','CONTACT_LANGUAGE','Contact Language','Contact Language',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='CORRESPONDENCE_LANGUAGE')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','CORRESPONDENCE_LANGUAGE','Correspondence Language','Correspondence Language',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='IS_ASYLUM_SEEKER')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','IS_ASYLUM_SEEKER','Asylum Seeker','Asylum Seeker',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='IS_PERMANENT_RESIDENT')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','IS_PERMANENT_RESIDENT','Permanent Residency','Permanent Residency',now(),1);
 END IF;
 
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='IS_TERTIARY_INSTITUTION')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','IS_TERTIARY_INSTITUTION','Did you or are you currently studying at a tertiary institution','Did you or are you currently studying at a tertiary institution',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='IS_WHEEL_CHAIR_REQUIRED')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','IS_WHEEL_CHAIR_REQUIRED','Wheel Chair Required','Wheel Chair Required',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SECONDARY_CITIZENSHIP')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SECONDARY_CITIZENSHIP','Secondary Citizenship','Secondary Citizenship',now(),1);
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='PORTAL_SETUP_NEW' and keyName='SUPPORT_DOCUMENT')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('PORTAL_SETUP_NEW','SUPPORT_DOCUMENT','Upload Support Document','Upload Support Document',now(),1);
 END IF;
 
  
END $$

-- Execute the stored procedure
CALL V20200610152025__Insert_UITrsForPortalNew $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20200610152025__Insert_UITrsForPortalNew $$
 
DELIMITER ;