DELIMITER $$
DROP PROCEDURE IF EXISTS V20200714155749__Create_AppHostelDetails $$
CREATE PROCEDURE V20200714155749__Create_AppHostelDetails()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='applicant_hostel_details')) THEN 
	
	CREATE TABLE `applicant_hostel_details` (
	  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	  `hostelId` BIGINT(20) NOT NULL,
	  `applicantHostelRequirementId` BIGINT(20) NOT NULL,
	  `lastUpdatedBy` BIGINT(20) NOT NULL,
	  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	  PRIMARY KEY (`id`),
	  CONSTRAINT `fk_applicant_hostel_details_hostelId`
	    FOREIGN KEY (`hostelId`)
	    REFERENCES `hostel` (`id`)
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION,
	  CONSTRAINT `fk_applicant_hostel_details_lastUpdatedBy`
	    FOREIGN KEY (`lastUpdatedBy`)
	    REFERENCES `users` (`id`)
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION,
	  CONSTRAINT `fk_applicant_hostel_details_applicantHostelRequirementId`
	    FOREIGN KEY (`applicantHostelRequirementId`)
	    REFERENCES `applicant_hostel_requirement` (`id`)
	    ON DELETE NO ACTION
	    ON UPDATE NO ACTION
	 ) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20200714155749__Create_AppHostelDetails () $$ 
DROP PROCEDURE IF EXISTS V20200714155749__Create_AppHostelDetails $$ 
DELIMITER ;
