DELIMITER $$
DROP PROCEDURE IF EXISTS V20200717181826__Create_course_requisites $$
CREATE PROCEDURE V20200717181826__Create_course_requisites()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_requisites' )) THEN 
CREATE TABLE `course_requisites` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseId` BIGINT(20) NOT NULL,
  `courseRelation` VARCHAR(45) NOT NULL,
  `relatedCourseId` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_course_requisites_1_idx` (`courseId` ASC),
  INDEX `fk_course_requisites_2_idx` (`relatedCourseId` ASC),
  INDEX `fk_course_requisites_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_course_requisites_1`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_requisites_2`
    FOREIGN KEY (`relatedCourseId`)
    REFERENCES `courses` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_course_requisites_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT)
    ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_requisite_criteria' )) THEN 
CREATE TABLE `course_requisite_criteria` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseRequisiteId` BIGINT(20) NULL DEFAULT NULL,
  `logicalOperator` VARCHAR(45) NULL DEFAULT NULL,
  `criteriaType` VARCHAR(45) NULL DEFAULT NULL,
  `courseRelationType` VARCHAR(45) NULL DEFAULT NULL ,
  `courseRelationOperand` VARCHAR(45) NULL DEFAULT NULL,
  `parentId` BIGINT(20) NULL DEFAULT NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_course_requisites_criteria_1_idx` (`CourseRequisiteId` ASC),
  INDEX `fk_course_requisites_criteria_2_idx` (`parentId` ASC),
  INDEX `fk_course_requisite_criteria_3_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_course_requisites_criteria_1`
    FOREIGN KEY (`CourseRequisiteId`)
	REFERENCES `course_requisites` (`id`)
	ON DELETE RESTRICT
	ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_requisites_criteria_2`
      FOREIGN KEY (`parentId`)
  REFERENCES `course_requisite_criteria` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    CONSTRAINT `fk_course_requisites_criteria_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MegaMenuConstants' and keyName='MANAGE_COURSE_REQUISITES')) THEN
    
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('MegaMenuConstants','MANAGE_COURSE_REQUISITES','Course Requisites','Course Requisites',now(),1);

  END IF;

END $$
CALL V20200717181826__Create_course_requisites () $$ 
DROP PROCEDURE IF EXISTS V20200717181826__Create_course_requisites $$ 
DELIMITER ;
