DELIMITER $$
DROP PROCEDURE IF EXISTS V20200723091738__Alter_ParentPaymentTermSettingN $$
CREATE PROCEDURE V20200723091738__Alter_ParentPaymentTermSettingN()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='parent_payment_term_settings')) THEN 
ALTER TABLE `parent_payment_term_settings` 
ADD COLUMN `parentFeedback` VARCHAR(255) NULL DEFAULT NULL AFTER `lastUpdatedBy`,
ADD COLUMN `parentReason` VARCHAR(255) NULL DEFAULT NULL AFTER `parentFeedback`,
ADD COLUMN `academyLocation` BIGINT NULL DEFAULT NULL AFTER `parentReason`,
ADD COLUMN `whetherRead` BIT(1) NOT NULL AFTER `academyLocation`,
ADD COLUMN `whetherMedical` BIT(1) NOT NULL AFTER `whetherRead`,
ADD COLUMN `whetherFeePayerDetailReviewed` BIT(1) NOT NULL AFTER `whetherMedical`,
ADD COLUMN `forNextYearHaveSibiling` BIT(1) NOT NULL AFTER `whetherFeePayerDetailReviewed`,
ADD COLUMN `currentYearBursary` BIT(1) NOT NULL AFTER `forNextYearHaveSibiling`,
ADD COLUMN `nextYearBursary` BIT(1) NOT NULL AFTER `currentYearBursary`,
ADD COLUMN `feePayerDetail` BIGINT NULL DEFAULT NULL AFTER `nextYearBursary`,
ADD COLUMN `medicalDetail` BIGINT NULL DEFAULT NULL AFTER `feePayerDetail`,
ADD INDEX `RefParentPaymentTermSettingToAcademyLocation_idx` (`academyLocation` ASC),
ADD INDEX `RefParentPaymentTermSettingToFeePayerDetail_idx` (`feePayerDetail` ASC),
ADD INDEX `RefParentPaymentTermSettingToMedicalDetail_idx` (`medicalDetail` ASC);
ALTER TABLE `parent_payment_term_settings` 
ADD CONSTRAINT `RefParentPaymentTermSettingToAcademyLocation`
  FOREIGN KEY (`academyLocation`)
  REFERENCES `academy_location` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `RefParentPaymentTermSettingToFeePayerDetail`
  FOREIGN KEY (`feePayerDetail`)
  REFERENCES `fee_payer_detail` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `RefParentPaymentTermSettingToMedicalDetail`
  FOREIGN KEY (`medicalDetail`)
  REFERENCES `medical_details` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF; 

END $$
CALL V20200723091738__Alter_ParentPaymentTermSettingN() $$
DROP PROCEDURE IF EXISTS V20200723091738__Alter_ParentPaymentTermSettingN $$
DELIMITER ;