DELIMITER $$
DROP PROCEDURE IF EXISTS V20200804140055__Create_LanguageCompetency $$
CREATE PROCEDURE V20200804140055__Create_LanguageCompetency()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='language_competency')) THEN 
CREATE TABLE `language_competency` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
   `personId` bigint(20) NOT NULL,
  `multilangId` bigint(20) DEFAULT NULL,
  `speakNo` bigint(20) DEFAULT NULL,
  `readNo` bigint(20) DEFAULT NULL,
  `writeNo`bigint(20) DEFAULT NULL,
 `lastUpdatedBy` bigint(20) DEFAULT NULL,
 `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_language_competency_lastupdatedby_idx` (`lastUpdatedBy`),
KEY `fk_language_competency_employeeId_idx` (`personId`),
 KEY `fk_language_competency_salutationId_idx` (`multilangId`),
CONSTRAINT `fk_salutationId_language_competency` FOREIGN KEY (`multilangId`) REFERENCES `multi_language` (`id`),
CONSTRAINT `fk_language_competency_employeeId` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
 CONSTRAINT `fk_lastupdatedby_language_competency` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20200804140055__Create_LanguageCompetency () $$ 
DROP PROCEDURE IF EXISTS V20200804140055__Create_LanguageCompetency $$ 
DELIMITER ;