DELIMITER $$
DROP PROCEDURE IF EXISTS V20200808142315__Delete_CourseRequisites $$
CREATE PROCEDURE V20200808142315__Delete_CourseRequisites()
BEGIN

IF EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='course_requisites' AND column_name='relatedCourseId')) THEN 
set sql_safe_updates=0;
delete from course_requisites where (courseRelation = 'CO_REQUISITE' or courseRelation = 'MUTUALLY_EXCLUSIVE') and relatedCourseId is not null;
delete from batch_course_requisites where (courseRelation = 'CO_REQUISITE' or courseRelation = 'MUTUALLY_EXCLUSIVE') and relatedCourseId is not null;
set sql_safe_updates=1;

ALTER TABLE `course_requisites` 
DROP FOREIGN KEY `fk_course_requisites_2`;
ALTER TABLE `course_requisites` 
DROP COLUMN `relatedCourseId`,
DROP INDEX `fk_course_requisites_2_idx` ;

ALTER TABLE `batch_course_requisites` 
DROP FOREIGN KEY `fk_batch_course_requisites_2`;
ALTER TABLE `batch_course_requisites` 
DROP COLUMN `relatedCourseId`,
DROP INDEX `fk_batch_course_requisites_2_idx` ;

END IF; 

END $$
CALL V20200808142315__Delete_CourseRequisites() $$
DROP PROCEDURE IF EXISTS V20200808142315__Delete_CourseRequisites $$
DELIMITER ;