DELIMITER $$
DROP PROCEDURE IF EXISTS V20200812193114__Create_DocumentGroupMaster $$
CREATE PROCEDURE V20200812193114__Create_DocumentGroupMaster()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='document_group_master')) THEN 
CREATE TABLE `document_group_master` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `groupName` VARCHAR(255) NOT NULL,
  `status` BIT(1) NOT NULL,
  `dueOn` DATE NOT NULL,
  `applicableTo` VARCHAR(45) NOT NULL,
  `allowUploadAfterDueDate` BIT(1) NOT NULL,
  `isMultipleTimeUpload` BIT(1) NOT NULL,
  `isDocumentRequested` BIT(1) NOT NULL,
  `description` TEXT(1000) NULL,
  `lastUpdatedBy` BIGINT(20) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `groupName_UNIQUE` (`groupName` ASC),
  INDEX `fk_dgm_user_id_idx` (`lastUpdatedBy` ASC),
   CONSTRAINT `fk_dgm_user_id`
    FOREIGN KEY (lastUpdatedBy)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200812193114__Create_DocumentGroupMaster () $$ 
DROP PROCEDURE IF EXISTS V20200812193114__Create_DocumentGroupMaster $$ 
DELIMITER ;