DELIMITER $$
DROP PROCEDURE IF EXISTS V20200831153816__Create_EmployeeAvailabilityTable $$
CREATE PROCEDURE V20200831153816__Create_EmployeeAvailabilityTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='employee_availability' )) THEN 
CREATE TABLE `employee_availability` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `employeeId` BIGINT(20) NOT NULL,
  `employeeWeekday` VARCHAR(45) NOT NULL,
  `availableFrom`  datetime NULL,
  `availableTo`  datetime NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_employee_availability_employeeId`
    FOREIGN KEY (`employeeId`)
    REFERENCES `staffs` (`personId`),
    CONSTRAINT `fk_employee_availability_Id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
     )
    ENGINE=InnoDB DEFAULT CHARSET=utf8;
  
END IF; 


END $$
CALL V20200831153816__Create_EmployeeAvailabilityTable () $$ 
DROP PROCEDURE IF EXISTS V20200831153816__Create_EmployeeAvailabilityTable $$ 
DELIMITER ;
