DELIMITER $$
DROP PROCEDURE IF EXISTS V20200831173316__Create_V2D151521_application_fee_view $$
CREATE PROCEDURE V20200831173316__Create_V2D151521_application_fee_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'application_fee_view')) THEN 
DROP view `application_fee_view`;
END IF; 

IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS
       WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'application_fee_view')) THEN 
	CREATE OR REPLACE VIEW `application_fee_view` AS select 
	
	`bfprs`.`billableAmount` AS `INVOICES`,
        `fh`.`feeHeadName` AS `FEE_HEAD`,
        (CASE
            WHEN (`bfprs`.`balanceAmount` = 0.00) THEN 'SETTLED'
            WHEN
                (((`bfprs`.`billableAmount` - `bfprs`.`adjustedAmount`) <> 0.00)
                    AND ((`bfprs`.`billableAmount` - `bfprs`.`adjustedAmount`) <> `bfprs`.`billableAmount`))
            THEN
                'PARTLYSETTLED'
            WHEN (`bfprs`.`balanceAmount` = `bfprs`.`billableAmount`) THEN 'UNSETTLED'
        END) AS `SETTLEMENT_STATUS`,
        sum(`fad`.`adjustedAmount`) AS `RECEIPTS`,
        (`bfprs`.`billableAmount` - sum(`fad`.`adjustedAmount`)) AS `OUTSTANDING_AMOUNT`,
        `bfprs`.`balanceAmount` AS `OUTSTANDING_AMOUNT_BILL_SETTLED`,
        `app`.`id` AS `APPLICATION_ID`,
        `app`.`code` AS `APPLICATION_CODE`,
        `app`.`currentStatus` AS `APPLICATION_STATUS`,
        `app`.`applicationCreatedOn` AS `APPLICATION_DATE`,
        `ap`.`printName` AS `APPLICANT_NAME`,
        `ap`.`gender` AS `Gender`,
        `p`.`programName` AS `PROGRAM_NAME`,
        `b`.`batchName` AS `BATCH_NAME`,
        `iy`.`itemCode` AS `INTAKE_YEAR`,
        `iy`.`id` AS `intakeYearId`,
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `ac`.`academyName` AS `ACADEMY_NAME`,
        `lc`.`locationName` AS `LOCATION_NAME`,
        `p`.`id` AS `PROGRAM_ID`,
        `b`.`id` AS `BATCH_ID`,
        `al`.`displayName` AS `ACADEMY_LOCATION_NAME`
    FROM
        ((((((((((((((`bill_header` `bh`
        LEFT JOIN `bill_fee_plan_rule_stage` `bfprs` ON ((`bh`.`id` = `bfprs`.`billId`)))
        LEFT JOIN `academy_location` `al` ON ((`bh`.`academyLocationId` = `al`.`id`)))
        LEFT JOIN `academies` `ac` ON ((`al`.`academyId` = `ac`.`id`)))
        LEFT JOIN `locations` `lc` ON ((`al`.`locationId` = `lc`.`id`)))
        LEFT JOIN `application` `app` ON ((`bh`.`applicantId` = `app`.`id`)))
        LEFT JOIN `application_program` `aap` ON ((`app`.`id` = `aap`.`applicationId`)))
        LEFT JOIN `prog_batch_seat_config` `pbsc` ON ((`pbsc`.`id` = `aap`.`progBatchSeatConfigId`)))
        LEFT JOIN `batches` `b` ON ((`pbsc`.`programBatchId` = `b`.`id`)))
        LEFT JOIN `programs` `p` ON ((`b`.`programId` = `p`.`id`)))
        LEFT JOIN `intake_year` `iy` ON ((`b`.`intakeYearId` = `iy`.`id`)))
        LEFT JOIN `applicant_person` `ap` ON ((`app`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `fee_stage_head_config` `fhc` ON ((`bfprs`.`feeStageHeadConfigId` = `fhc`.`id`)))
        LEFT JOIN `fee_heads` `fh` ON ((`fhc`.`feeHeadId` = `fh`.`id`)))
        LEFT JOIN `fee_adjustment_details` `fad` ON ((`bfprs`.`id` = `fad`.`billFeeRuleStageId`)))
    WHERE
        ((`bh`.`applicantId` IS NOT NULL)
            AND (`bh`.`billStatus` <> 'CANCELLED')
            AND (`bh`.`raiseBillCategory` = 'BILL_RECEIVABLE'))
    GROUP BY `bfprs`.`id` , `al`.`id`;
	END IF;
	


END $$
CALL V20200831173316__Create_V2D151521_application_fee_view () $$ 
DROP PROCEDURE IF EXISTS V20200831173316__Create_V2D151521_application_fee_view $$ 
DELIMITER ;