DELIMITER $$
DROP PROCEDURE IF EXISTS V20200901104656__Create_V121522_enquiry_target_view $$
CREATE PROCEDURE V20200901104656__Create_V121522_enquiry_target_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'enquiry_target_view')) THEN 
DROP view `enquiry_target_view`;
END IF;

IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='enquiry_target_view')) THEN 
Create Or Replace View enquiry_target_view as 
select a.academyLocationId,b.academyName as Brand_Name,b.locationName as Campus_Name,
b.displayName as Brand_Campus_Name,c.groupName as School_Phase,
d.programNameToBePrint as Grade_Name,d.ProgramSequence as Grade_Sequence,
e.printName as Intake,f.itemvalue as Intake_Year,a.enquiryTarget as Lead_Target,
a.applicationTarget as Application_Target,a.enrolmentPreviousYear as Enrollment_Previous_Year

from manage_target a left join academy_location b on(a.academyLocationId=b.id)
left join program_group c on(a.programGroupId=c.id)
left join programs d on(a.programId=d.id)
left join batches e on(a.batchId=e.id)
left join intake_year f on(a.intakeYearId=f.id);
END IF; 

END $$
CALL V20200901104656__Create_V121522_enquiry_target_view () $$ 
DROP PROCEDURE IF EXISTS V20200901104656__Create_V121522_enquiry_target_view $$ 
DELIMITER ;