DELIMITER $$
DROP PROCEDURE IF EXISTS V20200923152537__Insert_AssessmentSchemNCoursesReport $$
CREATE PROCEDURE V20200923152537__Insert_AssessmentSchemNCoursesReport()
BEGIN
	
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'ASSESSMENT_SCHEME_COURSES_REPORT' )) THEN 
set @assessment = (select id from report_type WHERE typeName = 'Assessment Scheme Reports');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@assessment, 'ASSESSMENT_SCHEME_COURSES_REPORT', 'Assessment Scheme & Course Report', 'ASSESSMENT_SCHEME_AND_COURSES_REPORT.png', 'ASSESS_SCHEME_CommonReport_Excel.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'ASSESSMENT_SCHEME_AND_COURSES_REPORT.jasper', 'AcademiaLogo.png'); 


set @scheme = (select id from report_template where templateCode ='ASSESSMENT_SCHEME_COURSES_REPORT');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_REPORT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_REPORT_NAME', 'Assessment scheme & courses report', '1', now());
 END IF;
 
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_PROGRAM', 'Program:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_BATCH')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_BATCH', 'Batch:', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_PERIOD')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_PERIOD', 'Period:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_COURSE_CODE', 'Course Code', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_COURSE_CREDITS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_COURSE_CREDITS', 'Course Credits', '1', now());
 END IF;
 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_MAX_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_MAX_MARKS', 'Max. Marks/Grade', '1', now());
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_MIN_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_MIN_MARKS', 'Min. Marks/Grade', '1', now());
 END IF;
 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @scheme and keyValue='TRANS_ASSESSMENT_SCHEME_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@scheme, 'TRANS_ASSESSMENT_SCHEME_NAME', 'Assessment Scheme Name', '1', now());
 END IF;
END IF;
END $$
CALL V20200923152537__Insert_AssessmentSchemNCoursesReport() $$
DROP PROCEDURE IF EXISTS V20200923152537__Insert_AssessmentSchemNCoursesReport $$
DELIMITER ;
