CREATE 
 OR REPLACE VIEW `student_promoted_list_view` AS
    SELECT 
        `prom`.`status` AS `status`,
        `usr`.`printName` AS `user_name`,
        `al_from`.`id` AS `academy_location_id`,
        `acad_from`.`academyName` AS `brand_name`,
        `loc_from`.`locationName` AS `campus_name`,
        `adm`.`code` AS `admission_id`,
        `usrs`.`code` AS `student_id`,
        `usrs`.`printName` AS `student_name`,
        `prog_from`.`programNameToBePrint` AS `from_grade`,
        `batch_from`.`printName` AS `from_intake`,
        `prog_batch_period_from`.`printName` AS `from_period`,
        `prom`.`approvalDate` AS `promotion_date`,
        `usrs`.`id` AS `user_id`,
        (CASE
            WHEN (`usrs`.`status` = 1) THEN 'active'
            WHEN (`usrs`.`status` = 0) THEN 'inactive'
            ELSE NULL
        END) AS `student_status`,
        `prog_to`.`programNameToBePrint` AS `to_grade`,
        `batch_to`.`printName` AS `to_intake`,
        `prog_batch_period_to`.`printName` AS `to_period`
    FROM
        (((((((((((((((`promotion` `prom`
        LEFT JOIN `users` `usr` ON ((`prom`.`lastUpdatedBy` = `usr`.`id`)))
        LEFT JOIN `program_batch_students` `program_batch_stu_from` ON ((`prom`.`fromRecordId` = `program_batch_stu_from`.`id`)))
        LEFT JOIN `prog_batch_period_config` `prog_batch_period_from` ON ((`program_batch_stu_from`.`progBatchPeriodConfigId` = `prog_batch_period_from`.`id`)))
        LEFT JOIN `batches` `batch_from` ON ((`prog_batch_period_from`.`programBatchId` = `batch_from`.`id`)))
        LEFT JOIN `programs` `prog_from` ON ((`batch_from`.`programId` = `prog_from`.`id`)))
        LEFT JOIN `academy_location` `al_from` ON ((`prog_from`.`academyLocationId` = `al_from`.`id`)))
        LEFT JOIN `academies` `acad_from` ON ((`al_from`.`academyId` = `acad_from`.`id`)))
        LEFT JOIN `locations` `loc_from` ON ((`al_from`.`locationId` = `loc_from`.`id`)))
        LEFT JOIN `admission` `adm` ON ((`program_batch_stu_from`.`admissionId` = `adm`.`id`)))
        LEFT JOIN `students` `stu` ON ((`adm`.`studentId` = `stu`.`userId`)))
        LEFT JOIN `users` `usrs` ON ((`stu`.`userId` = `usrs`.`id`)))
        LEFT JOIN `program_batch_students` `program_batch_stu_to` ON ((`prom`.`toRecordId` = `program_batch_stu_to`.`id`)))
        LEFT JOIN `prog_batch_period_config` `prog_batch_period_to` ON ((`program_batch_stu_to`.`progBatchPeriodConfigId` = `prog_batch_period_to`.`id`)))
        LEFT JOIN `batches` `batch_to` ON ((`prog_batch_period_to`.`programBatchId` = `batch_to`.`id`)))
        LEFT JOIN `programs` `prog_to` ON ((`batch_to`.`programId` = `prog_to`.`id`)));

        
CREATE 
 OR REPLACE VIEW `student_transfer_report_view` AS
    SELECT 
        `servicereq2_`.`requestId` AS `service_Req_id`,
        `requester13_`.`printName` AS `student_print_name`,
        CONCAT(`toal8_`.`academyName`,
                '-',
                `toal8_`.`locationName`) AS `to_brand_campus`,
        `acad`.`academyName` AS `to_academy_name`,
        `loc`.`locationName` AS `to_location_name`,
        `acadf`.`academyName` AS `academy_name`,
        `locf`.`locationName` AS `location_name`,
        `tobatch7_`.`batchName` AS `to_batch`,
        `requester13_`.`code` AS `student_id`,
        CONCAT(`fromal9_`.`academyName`,
                '-',
                `fromal9_`.`locationName`) AS `from_brand_campus`,
        `executiond15_`.`effectiveTransferDate` AS `transfer_date`,
        `batch12_`.`batchName` AS `from_batch`,
        `fromprogra4_`.`programName` AS `from_program`,
        `toprogram6_`.`programName` AS `to_program`,
        (CASE
            WHEN (`requester13_`.`status` = 1) THEN 'Active'
            WHEN (`requester13_`.`status` = 0) THEN 'Inactive'
            ELSE NULL
        END) AS `student_status`
    FROM
        ((((((((((((((((((((((((((`service_requests` `this_`
        LEFT JOIN `service_request_settings` `servicereq17_` ON ((`this_`.`serviceRequestSettingId` = `servicereq17_`.`id`)))
        LEFT JOIN `execution_details` `executiond15_` ON ((`this_`.`id` = `executiond15_`.`serviceRequestId`)))
        LEFT JOIN `staffs` `executiond16_` ON ((`executiond15_`.`userId` = `executiond16_`.`userId`)))
        LEFT JOIN `users` `executiond16_1_` ON ((`executiond16_`.`userId` = `executiond16_1_`.`id`)))
        LEFT JOIN `student_transfer_request_details` `detail1_` ON ((`this_`.`id` = `detail1_`.`serviceRequestId`)))
        LEFT JOIN `service_requests` `servicereq2_` ON ((`detail1_`.`serviceRequestId` = `servicereq2_`.`id`)))
        JOIN `request_status` `requeststa3_` ON ((`servicereq2_`.`requestStatusId` = `requeststa3_`.`id`)))
        JOIN `users` `requester13_` ON ((`servicereq2_`.`requester` = `requester13_`.`id`)))
        LEFT JOIN `parents` `requester13_1_` ON ((`requester13_`.`id` = `requester13_1_`.`userId`)))
        LEFT JOIN `staffs` `requester13_2_` ON ((`requester13_`.`id` = `requester13_2_`.`userId`)))
        LEFT JOIN `students` `requester13_3_` ON ((`requester13_`.`id` = `requester13_3_`.`userId`)))
        JOIN `academy_location` `fromal9_` ON ((`detail1_`.`fromALId` = `fromal9_`.`id`)))
        JOIN `academies` `acadf` ON ((`fromal9_`.`academyId` = `acadf`.`id`)))
        JOIN `locations` `locf` ON ((`fromal9_`.`locationId` = `locf`.`id`)))
        JOIN `programs` `fromprogra4_` ON ((`detail1_`.`fromProgramId` = `fromprogra4_`.`id`)))
        JOIN `admission` `admissions10_` ON ((`fromprogra4_`.`id` = `admissions10_`.`programId`)))
        JOIN `academy_location` `academyloc14_` ON ((`admissions10_`.`academyLocationId` = `academyloc14_`.`id`)))
        JOIN `batches` `batch12_` ON ((`admissions10_`.`batchId` = `batch12_`.`id`)))
        JOIN `students` `student11_` ON ((`admissions10_`.`studentId` = `student11_`.`userId`)))
        LEFT JOIN `users` `student11_1_` ON ((`student11_`.`userId` = `student11_1_`.`id`)))
        JOIN `program_group` `programgro5_` ON ((`fromprogra4_`.`programGroupId` = `programgro5_`.`id`)))
        JOIN `academy_location` `toal8_` ON ((`detail1_`.`toALId` = `toal8_`.`id`)))
        JOIN `academies` `acad` ON ((`toal8_`.`academyId` = `acad`.`id`)))
        JOIN `locations` `loc` ON ((`toal8_`.`locationId` = `loc`.`id`)))
        JOIN `batches` `tobatch7_` ON ((`detail1_`.`toBatchId` = `tobatch7_`.`id`)))
        JOIN `programs` `toprogram6_` ON ((`detail1_`.`toProgramId` = `toprogram6_`.`id`)))
    WHERE
        ((`this_`.`type` = 'STUDENT_TRANSFER')
            AND (`admissions10_`.`activeStatus` = FALSE)
            AND (`servicereq2_`.`serviceRequestStage` = 'CLOSED')
            AND (`requeststa3_`.`itemCode` = 'Completed'))
    GROUP BY `servicereq2_`.`requestId`;

    
    
    CREATE 
 OR REPLACE VIEW `student_summary_view` AS
    SELECT 
        `al`.`id` AS `ACADEMY_LOCATION_ID`,
        `al`.`displayName` AS `BRAND_CAMPUS`,
        `al`.`academyCode` AS `ACADMEY_CODE`,
        `al`.`academyName` AS `BRAND_NAME`,
        `al`.`locationName` AS `CAMPUS_NAME`,
        `admission`.`id` AS `ADMISSION_ID`,
        `admission`.`code` AS `ADMISSION_NUMBER`,
        `studentuser`.`id` AS `STUDENT_ID`,
        `studentuser`.`code` AS `STUDENT_CODE`,
        `studentuser`.`printName` AS `STUDENT_NAME`,
        `program`.`programCode` AS `GRADE_CODE`,
        `program`.`id` AS `GRADE_ID`,
        `program`.`programName` AS `GRADE_NAME`,
        `program`.`programShortName` AS `GRADE_SHORT_NAME`,
        `program_group`.`groupName` AS `SCHOOL_PHASE`,
        `program_category`.`categoryName` AS `CLASS_CATEGORY`,
        `program`.`programMarkGrade` AS `GRADE_MARK_OR_GRADE`,
        `department`.`deptName` AS `GRADE_DEPARTMENT`,
        `sub_department`.`deptName` AS `GRADE_SUB_DEPARTMENT`,
        `program`.`programSequence` AS `GRADE_SEQUENCE`,
        `section`.`sectionCode` AS `CLASS_CODE`,
        `period`.`programPeriodName` AS `PERIOD`,
        `batch`.`batchName` AS `INTAKE`,
        `intake`.`itemValue` AS `INTAKE_YEAR`,
        `seattype`.`seatName` AS `SEAT_TYPE`,
        `admission`.`admissionDate` AS `DATE_OF_ADMISSION`,
        `person`.`birthDate` AS `DATE_OF_BIRTH`,
        DATE_FORMAT(FROM_DAYS((TO_DAYS(CURDATE()) - TO_DAYS(`person`.`birthDate`))),
                '%y Years %m Months %d Days') AS `AGE`,
        `studentuser`.`status` AS `STATUS`,
        `gender`.`itemValue` AS `GENDER`,
        `religions`.`itemValue` AS `RELIGION`,
        `category`.`itemValue` AS `ETHNICITY`,
        `address`.`addressText` AS `ADDRESS`,
        `country`.`countryName` AS `COUNTRY_NAME`,
        `country_region`.`countryRegionName` AS `COUNTRY_REGION_NAME`,
        `city`.`cityName` AS `CITY_NAME`,
        `nationalities`.`itemValue` AS `NATIONALITY`,
        `studentuser`.`emailId` AS `EMAIL`,
        CONCAT(`person`.`mobileCountryCode`,
                `person`.`mobileNumber`) AS `MOBILE_NO`,
        `allaction`.`actionCount` AS `DSCIPLINARY_ACTION`,
        `positiveaction`.`actionCount` AS `POSITIVE_INCIDENT`,
        `negativeaction`.`actionCount` AS `NEGATIVE_INCIDENT`
    FROM
        ((((((((((((((((((((((((((((`program_batch_students` `pbs`
        LEFT JOIN `sections` `section` ON ((`pbs`.`sectionId` = `section`.`id`)))
        JOIN `prog_batch_period_config` `period` ON ((`pbs`.`progBatchPeriodConfigId` = `period`.`id`)))
        JOIN `batches` `batch` ON ((`pbs`.`programBatchId` = `batch`.`id`)))
        LEFT JOIN `intake_year` `intake` ON ((`batch`.`intakeYearId` = `intake`.`id`)))
        JOIN `programs` `program` ON ((`batch`.`programId` = `program`.`id`)))
        JOIN `program_group` ON ((`program`.`programGroupId` = `program_group`.`id`)))
        JOIN `program_category` ON ((`program`.`programCategoryId` = `program_category`.`id`)))
        JOIN `department` ON ((`program`.`programDepartmentId` = `department`.`id`)))
        LEFT JOIN `department` `sub_department` ON ((`program`.`subDepartmentId` = `department`.`id`)))
        JOIN `admission` ON ((`pbs`.`admissionId` = `admission`.`id`)))
        JOIN `students` `student` ON ((`admission`.`studentId` = `student`.`userId`)))
        JOIN `users` `studentuser` ON ((`student`.`userId` = `studentuser`.`id`)))
        JOIN `persons` `person` ON ((`student`.`personId` = `person`.`id`)))
        LEFT JOIN `gender` ON ((`person`.`genderId` = `gender`.`id`)))
        LEFT JOIN `religions` ON ((`person`.`religionId` = `religions`.`id`)))
        LEFT JOIN `caste_categories` `category` ON ((`person`.`castCategoryId` = `category`.`id`)))
        LEFT JOIN `person_addresses` ON (((`person_addresses`.`personId` = `person`.`id`)
            AND (`person_addresses`.`whetherDeleted` = FALSE)
            AND (`person_addresses`.`whetherPrimary` = TRUE))))
        LEFT JOIN `address` ON ((`person_addresses`.`addressId` = `address`.`id`)))
        LEFT JOIN `country` ON ((`address`.`countryId` = `country`.`id`)))
        LEFT JOIN `country_region` ON ((`address`.`countryRegionId` = `country_region`.`id`)))
        LEFT JOIN `city` ON ((`address`.`cityId` = `city`.`id`)))
        LEFT JOIN `nationalities` ON ((`person`.`nationalityId` = `nationalities`.`id`)))
        JOIN `academy_location` `al` ON ((`program`.`academyLocationId` = `al`.`id`)))
        JOIN `prog_batch_seat_config` `seatconfig` ON ((`pbs`.`progBatchSeatConfigId` = `seatconfig`.`id`)))
        JOIN `seat_types` `seattype` ON ((`seatconfig`.`seatTypeId` = `seattype`.`id`)))
        LEFT JOIN (SELECT 
            COUNT(`disciplinary_actions`.`id`) AS `actionCount`,
                `disciplinary_actions`.`personId` AS `personId`
        FROM
            `disciplinary_actions`
        WHERE
            (`disciplinary_actions`.`whetherDeleted` = FALSE)) `allaction` ON ((`allaction`.`personId` = `person`.`id`)))
        LEFT JOIN (SELECT 
            COUNT(`disciplinary_actions`.`id`) AS `actionCount`,
                `disciplinary_actions`.`personId` AS `personId`
        FROM
            (`disciplinary_actions`
        LEFT JOIN `incident_types` ON ((`disciplinary_actions`.`incidentTypeId` = `incident_types`.`id`)))
        WHERE
            ((`disciplinary_actions`.`whetherDeleted` = FALSE)
                AND (`incident_types`.`category` = 'POSITIVE'))) `positiveaction` ON ((`positiveaction`.`personId` = `person`.`id`)))
        LEFT JOIN (SELECT 
            COUNT(`disciplinary_actions`.`id`) AS `actionCount`,
                `disciplinary_actions`.`personId` AS `personId`
        FROM
            (`disciplinary_actions`
        LEFT JOIN `incident_types` ON ((`disciplinary_actions`.`incidentTypeId` = `incident_types`.`id`)))
        WHERE
            ((`disciplinary_actions`.`whetherDeleted` = FALSE)
                AND (`incident_types`.`category` <> 'POSITIVE'))) `negativeaction` ON ((`negativeaction`.`personId` = `person`.`id`)))
    WHERE
        ((`pbs`.`isCurrentPeriod` = TRUE)
            AND (`pbs`.`isCurrentSection` = TRUE)
            AND (`pbs`.`exitDate` IS NULL));
