DELIMITER $$
DROP PROCEDURE IF EXISTS V20201012173441__Create_AdmConditionDetailTable $$
CREATE PROCEDURE V20201012173441__Create_AdmConditionDetailTable()
BEGIN

	IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='admission_condition_detail')) THEN 
		
		CREATE TABLE `admission_condition_detail`( 
		`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
		`applicationProgramId` BIGINT(20) NOT NULL,
		`admissionConditionId` BIGINT(20) NULL DEFAULT NULL,	
		`documentTypeId` BIGINT(20) NULL DEFAULT NULL,
		`lastUpdate` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		`lastUpdatedBy` BIGINT(20),
		PRIMARY KEY (`id`), 
		CONSTRAINT `admission_condition_detail_applicationProgramId_FK` FOREIGN KEY (`applicationProgramId`) REFERENCES `application_program`(`id`),
		CONSTRAINT `admission_condition_detail_admissionConditionId_FK` FOREIGN KEY (`admissionConditionId`) REFERENCES `admission_condition`(`id`),
		CONSTRAINT `admission_condition_detail_documentTypeId_FK` FOREIGN KEY (`documentTypeId`) REFERENCES `document_types`(`id`),
		CONSTRAINT `admission_condition_detail_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`))
		ENGINE=INNODB DEFAULT  CHARSET=utf8; 
	
	END IF; 
	
END $$
CALL V20201012173441__Create_AdmConditionDetailTable () $$ 
DROP PROCEDURE IF EXISTS V20201012173441__Create_AdmConditionDetailTable $$ 
DELIMITER ;
