DELIMITER $$

DROP PROCEDURE IF EXISTS V20201023105420__AlterEducationHistoryColumn $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201023105420__AlterEducationHistoryColumn()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='applicant_education_histories' 
  AND column_name='file_path')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `applicant_education_histories` ADD COLUMN `file_path` VARCHAR(250) NULL;
  
  END IF;
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='education_histories' 
  AND column_name='file_path')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `education_histories` ADD COLUMN `file_path` VARCHAR(250) NULL;
  
  END IF;
  
  IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='REPEATED_SCHOOL_SUBJECTS')) THEN
	INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','REPEATED_SCHOOL_SUBJECTS','Repeated School Subject(s)','Repeated School Subject(s)','Herhaalde skoolvak (te)','(Các) Chủ đề Trường học Lặp lại' ,now(),1);

END IF;  

END $$

-- Execute the stored procedure
CALL V20201023105420__AlterEducationHistoryColumn $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201023105420__AlterEducationHistoryColumn $$
 
DELIMITER ;