DELIMITER $$
DROP PROCEDURE IF EXISTS V20201026180716__Alter_ReceiptPaymentInstrument $$
CREATE PROCEDURE V20201026180716__Alter_ReceiptPaymentInstrument()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='receipt_payment_instrument' AND column_name='bankChargesHistoryId')) THEN 
ALTER TABLE `receipt_payment_instrument` 
ADD COLUMN `bankChargesHistoryId` BIGINT NULL DEFAULT NULL AFTER `orgCurrencyId`,
ADD INDEX `fk_receipt_payment_instrument_to_bank_charges_history_idx` (`bankChargesHistoryId` ASC);

ALTER TABLE `receipt_payment_instrument` 
ADD CONSTRAINT `fk_receipt_payment_instrument_to_bank_charges_history`
  FOREIGN KEY (`bankChargesHistoryId`)
  REFERENCES `bank_charges_history` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;

END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='receipt_payment_instrument' AND column_name='bankChargesPercentage')) THEN 
ALTER TABLE `receipt_payment_instrument` 
ADD COLUMN `bankChargesPercentage` DOUBLE(20,2) NULL DEFAULT NULL AFTER `bankChargesHistoryId`;
END IF; 


IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='receipt_payment_instrument' AND column_name='bankChargesAmount')) THEN 
ALTER TABLE `receipt_payment_instrument` 
ADD COLUMN `bankChargesAmount` DOUBLE(20,2) NULL DEFAULT NULL AFTER `bankChargesPercentage`;

END IF; 

END $$
CALL V20201026180716__Alter_ReceiptPaymentInstrument() $$
DROP PROCEDURE IF EXISTS V20201026180716__Alter_ReceiptPaymentInstrument $$
DELIMITER ;