DELIMITER $$
DROP PROCEDURE IF EXISTS V20201109211356__Create_ElectionListCandidate $$
CREATE PROCEDURE V20201109211356__Create_ElectionListCandidate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='election_list_candidate')) THEN 
CREATE TABLE `election_list_candidate` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `electionListId` BIGINT(20) NOT NULL,
  `candidateType` VARCHAR(255) NOT NULL,
  `candidateId` BIGINT(20) DEFAULT NULL,
  `candidateName` VARCHAR(255) DEFAULT NULL,
  `mobileCountryCode` VARCHAR(10) NULL,
  `mobileNumber` VARCHAR(20) NULL,
  `emailId` VARCHAR(20) NULL,
  `imageUrl` VARCHAR(1000) NULL,
  `candidateStatement` TEXT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_elc_candidate_election_list_id_idx` (`electionListId` ASC),
  INDEX `fk_elc_candidate_candidate_id_idx` (`candidateId` ASC),
  INDEX `fk_elc_candidate_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_elc_candidate_election_list_id`
    FOREIGN KEY (`electionListId`)
    REFERENCES `election_list` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_elc_candidate_candidate_id`
    FOREIGN KEY (`candidateId`)
    REFERENCES `persons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_elc_candidate_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20201109211356__Create_ElectionListCandidate () $$ 
DROP PROCEDURE IF EXISTS V20201109211356__Create_ElectionListCandidate $$ 
DELIMITER ;