SET SQL_SAFE_UPDATES=0;

SET @msgExternalUser=(SELECT id FROM dtprovider WHERE `dataProviderName`='ADD_EXTERNAL_USER_RECIPIENT_INFO');
UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
   T1.`id` AS ID,
   T4.`firstName` AS FIRST_NAME,
   T4.`middleName` AS MIDDLE_NAME,
   T4.`lastName` AS LAST_NAME,
   T4.`printName` AS PRINT_NAME,
   T4.`emailId` AS EMAIL_ID,
   T4.`mobileNumber` AS MOBILE_NO,
   T4.`mobileCountryCode` AS MOBILE_CODE,
   ml.`code` as LANGUAGE_KEY,
	(CASE
        WHEN
            T6.`logoUrl` IS NULL
                AND org.`orgUrl` IS NOT NULL
        THEN
            CONCAT(org.`orgUrl`,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T6.`logoUrl` IS NULL
                AND org.`orgUrl` IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.`orgUrl`, '/', T6.`logoUrl`)
    END) AS LOGO_URL,
    T6.`displayName` AS ACADEMY_NAME_LOCATION,
    T8.`primaryeEmailId` AS ACADEMY_EMAILID,
    T8.`addressText` AS AL_ADDRESS_TEXT,
    T12.`countryName` AS AL_ADDRESS_COUNTRY_NAME,
    
    (CASE
        WHEN
            T11.`countryRegionName` IS NOT NULL
        THEN
            T11.`countryRegionName`
        WHEN
            T19.`countryRegionName` IS NOT NULL
        THEN
            T19.`countryRegionName`
        ELSE ''
    END) AS AL_ADDRESS_COUNTRY_REGION_NAME,
    T10.`cityName` AS AL_ADDRESS_CITY_NAME,    
    (CASE
        WHEN
            T8.`cellCountryCode` IS NOT NULL
                AND T8.`cellNo` IS NOT NULL
        THEN
            CONCAT(T8.`cellCountryCode`, ' ', T8.`cellNo`)
        WHEN
            T8.`cellCountryCode` IS NULL
                AND T8.`cellNo` IS NOT NULL
        THEN
            T8.`cellNo`
        ELSE ''
    END) AS AL_MOBILE_NO,
    (CASE
        WHEN
            T8.`phoneCountryCode` IS NOT NULL
                AND T8.`phoneAreaCode` IS NOT NULL
                AND T8.`phoneNo` IS NOT NULL
        THEN
            CONCAT(T8.`phoneCountryCode`,' ',T8.`phoneAreaCode`, ' ', T8.`phoneNo`)
        WHEN
            T8.`phoneCountryCode` IS NULL
                AND T8.`phoneAreaCode` IS NULL
                AND T8.`phoneNo` IS NOT NULL
        THEN
            T8.`phoneNo`
        ELSE ''
    END) AS AL_PHONE_NO,
    T13.`printName` AS APPLICATION_OWNER_NAME,
    T16.`programNameToBePrint` AS PROGRAM_NAME,
    T18.`printName` AS BATCH_NAME,
    T13.`emailId` AS APPLICATION_OWNER_EMAIL,
    (CASE
        WHEN
            T15.`mobileCountryCode` IS NOT NULL
                AND T15.`mobileNumber` IS NOT NULL
        THEN
            CONCAT(T15.`mobileCountryCode`, ' ', T15.`mobileNumber`)
        WHEN
            T15.`mobileCountryCode` IS NULL
                AND T15.`mobileNumber` IS NOT NULL
        THEN
            T15.`mobileNumber`
        ELSE ''
    END) AS APPLICATION_OWNER_MOBILE_NO
FROM
	external_users T1
	left join external_user_association T2 on T2.externalUserId=T1.id
    left join application T3 on T3.id=T2.applicationId
    left join applicant_person T4 on T4.id=T3.applicantPersonId 
    left join multi_language ml on T4.correspondence_language=ml.id
		LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
		LEFT JOIN
    application_program T5 ON T5.applicationId = T2.id
        LEFT OUTER JOIN
    academy_location T6 ON T6.id = T5.academyLocationId
        LEFT OUTER JOIN
    academy_location_addresses T7 ON T7.academyLocationId = T6.id
        LEFT OUTER JOIN
    address T8 ON T8.id = T7.addressId
		LEFT OUTER JOIN
    country T9 ON T9.id = T8.countryId
		LEFT OUTER JOIN
    city T10 ON T10.id = T8.cityId
		LEFT OUTER JOIN
    country_region T11 ON T11.id = T8.parentRegionId
		LEFT OUTER JOIN
    country_region T19 ON T19.id = T8.countryRegionId
        LEFT OUTER JOIN
    country T12 ON T12.id = T11.countryId
		LEFT OUTER JOIN
	users T13 on T13.id = T3.applicationOwner
		LEFT OUTER JOIN
	staffs T14 on T14.userId = T13.id
		LEFT OUTER JOIN
	persons T15 on T15.id = T14.personId
		LEFT OUTER JOIN
	programs T16 on T16.id = T5.programId
		LEFT OUTER JOIN
	prog_batch_seat_config T17 on T17.id = T5.progBatchSeatConfigId
		LEFT OUTER JOIN
	batches T18 on T18.id = T17.programBatchId
WHERE
    T1.id IN (namedParams)
    AND T8.addressTypeId = 10",`jsonString`='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
    {
            "id": 5,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "mobileCode",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyLocationName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "academyLocationEmail",
            "resultKey": "ACADEMY_EMAILID",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "alAddressText",
            "resultKey": "AL_ADDRESS_TEXT",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "alAddressCountryName",
            "resultKey": "AL_ADDRESS_COUNTRY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "alAddressCountryRegionName",
            "resultKey": "AL_ADDRESS_COUNTRY_REGION_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "alAddressCityName",
            "resultKey": "AL_ADDRESS_CITY_NAME",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "alMobileNo",
            "resultKey": "AL_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 15
        },
        {
            "id": 17,
            "value": "alPhoneNo",
            "resultKey": "AL_PHONE_NO",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "applicationOwnerName",
            "resultKey": "APPLICATION_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "applicationOwnerEmail",
            "resultKey": "APPLICATION_OWNER_EMAIL",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "applicationOwnerMobileNo",
            "resultKey": "APPLICATION_OWNER_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 19
        },
        {
            "id": 21,
            "value": "programName",
            "resultKey": "PROGRAM_NAME",
            "displayCode": "",
            "displayOrder": 20
        },
        {
            "id": 22,
            "value": "batchName",
            "resultKey": "BATCH_NAME",
            "displayCode": "",
            "displayOrder": 21
        }
    ]
}
' WHERE `dataProviderId`=@msgExternalUser;

SET SQL_SAFE_UPDATES=1;