DELIMITER $$
DROP PROCEDURE IF EXISTS V20201110162216__Create_CourseFeeSubHead $$
CREATE PROCEDURE V20201110162216__Create_CourseFeeSubHead()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='course_fee_sub_head')) THEN 
CREATE TABLE `course_fee_sub_head` (
  `id` BIGINT NOT NULL,
  `courseFeeDefinationId` BIGINT NOT NULL,
  `serialNo` BIGINT NOT NULL,
  `feeHeadId` BIGINT NOT NULL,
  `amountOrWeightage` DOUBLE(20,2) NULL,
  `costCentreId` BIGINT NULL,
  `isRefundable` BIT(1) NULL,
  `droolRuleId` BIGINT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NOT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_course_fee_sub_head_to_course_fee_defination_idx` (`courseFeeDefinationId` ASC) VISIBLE,
  INDEX `fk_course_fee_sub_head_to_fee_heads_idx` (`feeHeadId` ASC) VISIBLE,
  INDEX `fk_course_fee_sub_head_to_cost_centre_idx` (`costCentreId` ASC) VISIBLE,
  INDEX `fk_course_fee_sub_head_to_drool_rule_idx` (`droolRuleId` ASC) VISIBLE,
  INDEX `fk_course_fee_sub_head_to_user_idx` (`lastUpdatedBy` ASC) VISIBLE,
  CONSTRAINT `fk_course_fee_sub_head_to_course_fee_defination`
    FOREIGN KEY (`courseFeeDefinationId`)
    REFERENCES `academic_award` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_sub_head_to_fee_heads`
    FOREIGN KEY (`feeHeadId`)
    REFERENCES `fee_heads` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_sub_head_to_cost_centre`
    FOREIGN KEY (`costCentreId`)
    REFERENCES `cost_centre` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_course_fee_sub_head_to_drool_rule`
    FOREIGN KEY (`droolRuleId`)
    REFERENCES `drool_rules` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_course_fee_sub_head_to_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);

END IF; 

END $$
CALL V20201110162216__Create_CourseFeeSubHead () $$ 
DROP PROCEDURE IF EXISTS V20201110162216__Create_CourseFeeSubHead $$ 
DELIMITER ;