DELIMITER $$
DROP PROCEDURE IF EXISTS V20201111132427__Create_ElectionVoterPool $$
CREATE PROCEDURE V20201111132427__Create_ElectionVoterPool()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='election_voter_pool')) THEN 
CREATE TABLE `election_voter_pool` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `electionId` BIGINT(20) NOT NULL,
  `personId` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_ev_pool_election_id_idx` (`electionId` ASC),
  INDEX `fk_ev_pool_person_id_idx` (`personId` ASC),
  INDEX `fk_ev_pool_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_ev_pool_election_id`
    FOREIGN KEY (`electionId`)
    REFERENCES `election` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
 CONSTRAINT `fk_ev_pool_person_id`
    FOREIGN KEY (`personId`)
    REFERENCES `persons` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_ev_pool_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20201111132427__Create_ElectionVoterPool () $$ 
DROP PROCEDURE IF EXISTS V20201111132427__Create_ElectionVoterPool $$ 
DELIMITER ;