DELIMITER $$
DROP PROCEDURE IF EXISTS V20201203125710__CreateCustomFieldEnqFormSetup $$
CREATE PROCEDURE V20201203125710__CreateCustomFieldEnqFormSetup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='custom_field_config_enquiryform_setup')) THEN 
CREATE TABLE custom_field_config_enquiryform_setup (
    id BIGINT(20) AUTO_INCREMENT primary key,
    academy_location_id BIGINT(20) DEFAULT NULL,
    custom_field_config_id BIGINT(20) DEFAULT NULL,
    entity_type VARCHAR(50) DEFAULT NULL,
    whether_custom_field BIT(1) DEFAULT NULL,
    is_visible TINYINT(1) DEFAULT NULL,
    is_mandatory TINYINT(1) DEFAULT NULL,
    lastUpdate  TIMESTAMP DEFAULT  CURRENT_TIMESTAMP,
    lastUpdatedBy BIGINT(20),
    KEY `fk_config_enquiryform_setup_al_idx` (`academy_location_id`),
 	KEY `fk_config_enquiryform_setup_config_idx` (`custom_field_config_id`),
    KEY `fk_config_enquiryform_setup_updated_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_config_enquiryform_setup_academy_loc` FOREIGN KEY (`academy_location_id`) REFERENCES `academy_location` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_config_enquiryform_setup_updated` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_config_enquiryform_setup_field_config` FOREIGN KEY (`custom_field_config_id`) REFERENCES `custom_field_config` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
);
END IF; 

END $$
CALL V20201203125710__CreateCustomFieldEnqFormSetup () $$ 
DROP PROCEDURE IF EXISTS V20201203125710__CreateCustomFieldEnqFormSetup $$ 
DELIMITER ;