DELIMITER $$
DROP PROCEDURE IF EXISTS V20201222172902__Create_add_transfer_credit_details $$
CREATE PROCEDURE V20201222172902__Create_add_transfer_credit_details()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='add_transfer_credit_details')) THEN 
CREATE TABLE `add_transfer_credit_details` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `periodId` bigint(20) NOT NULL,
  `admissionId` bigint(20) NOT NULL,
  `courseId` bigint(20) NOT NULL,
  `evaluationPlanId` bigint(20) NOT NULL,
  `externalCoursePeriodId` bigint(20) DEFAULT NULL,
  `externalCourseCode` VARCHAR(50) DEFAULT NULL,
  `externalCourseName` VARCHAR(50) DEFAULT NULL,
  `externalCourseInstitute` VARCHAR(250) DEFAULT NULL,
  `externalCourseGrade` VARCHAR(50) DEFAULT NULL,
  `externalCourseMarks` VARCHAR(50) DEFAULT NULL,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_add_transfer_credit_1_idx` (`periodId`),
  KEY `fk_add_transfer_credit_2_idx` (`admissionId`),
  KEY `fk_add_transfer_credit_3_idx` (`courseId`),
  KEY `fk_add_transfer_credit_4_idx` (`evaluationPlanId`),
  KEY `fk_add_transfer_credit_5_idx` (`externalCoursePeriodId`),
  KEY `fk_add_transfer_credit_6_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_add_transfer_credit_1` FOREIGN KEY (`periodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_add_transfer_credit_2` FOREIGN KEY (`admissionId`) REFERENCES `admission` (`id`),
  CONSTRAINT `fk_add_transfer_credit_3` FOREIGN KEY (`courseId`) REFERENCES `courses` (`id`),
  CONSTRAINT `fk_add_transfer_credit_4` FOREIGN KEY (`evaluationPlanId`) REFERENCES `evaluation_plan` (`id`),
  CONSTRAINT `fk_add_transfer_credit_5` FOREIGN KEY (`externalCoursePeriodId`) REFERENCES `prog_batch_period_config` (`id`),
  CONSTRAINT `fk_add_transfer_credit_6` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
);
END IF; 

END $$
CALL V20201222172902__Create_add_transfer_credit_details () $$ 
DROP PROCEDURE IF EXISTS V20201222172902__Create_add_transfer_credit_details $$ 
DELIMITER ;
