DELIMITER $$
DROP PROCEDURE IF EXISTS V20201230174312__Insert_UPNGReceiptSettlementCore $$
CREATE PROCEDURE V20201230174312__Insert_UPNGReceiptSettlementCore()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '4' AND templateCode = 'MANAGE_RECEIPT_SETTLEMENT_CODE' AND templateName='UPNG Receipt Settlement')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('4','MANAGE_RECEIPT_SETTLEMENT_CODE', 'UPNG Receipt Settlement', 'ReceiptCollege.png', 'CommonReport_Remove_ExtraPage.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'UPNG_RECEIPT_SINGLE.jasper', 'AcademiaLogo.png');

set @reportTempId = (select max(id) from report_template where templateCode ='MANAGE_RECEIPT_SETTLEMENT_CODE');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTempId, 'TRANS_RECEIPT_NO', 'Receipt No.', '1', NOW()),
(@reportTempId, 'TRANS_RECEIPT_DATE', 'Receipt Date', '1', NOW()),
(@reportTempId, 'TRANS_ID', 'ID', '1', NOW()),
(@reportTempId, 'TRANS_BILL_NO', 'Being Payment Of Invoice Ref', '1', NOW()),
(@reportTempId, 'TRANS_PREF_NAME', 'Mr./Ms.', '1', NOW()),
(@reportTempId, 'TRANS_ASUMOF', 'a sum of', '1', NOW()),
(@reportTempId, 'TRANS_DATE', 'Invoice Date', '1', NOW()),
(@reportTempId, 'TRANS_INSTRUMENT_NO', 'Cash/Cheque No', '1', NOW()),
(@reportTempId, 'TRANS_FOR', 'For', '1', NOW()),
(@reportTempId, 'TRANS_ACCOUNT_NO', 'Account No.', '1', NOW());



END IF; 

END $$
CALL V20201230174312__Insert_UPNGReceiptSettlementCore() $$
DROP PROCEDURE IF EXISTS V20201230174312__Insert_UPNGReceiptSettlementCore $$
DELIMITER ;