DELIMITER $$
DROP PROCEDURE IF EXISTS V20201231165104__Insert_UPNGStatementOfAcc $$
CREATE PROCEDURE V20201231165104__Insert_UPNGStatementOfAcc()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE reportTypeId = '6' AND templateCode = 'VELOCITY_STATEMENT_OF_ACCOUNT' AND templateName='UPNG Statement of Account')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('6','VELOCITY_STATEMENT_OF_ACCOUNT', 'UPNG Statement of Account','STATEMENT_OF_ACCOUNT.png', 'CommonReport.jasper', 'All', '0', 'FooterBlank.jasper', 'FooterBlank.jasper', '0', '0', 'UPNG_STATE_ACC.jasper', 'AcademiaLogo.png');

set @reportTempId = (select max(id) from report_template where templateCode ='VELOCITY_STATEMENT_OF_ACCOUNT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@reportTempId, 'TRANS_STUDENT_NAME', 'Student Name', '1', NOW()),
(@reportTempId, 'TRANS_STUDENT_ID', 'Student Id', '1', NOW()),
(@reportTempId, 'TRANS_ADDRESS', 'Address', '1', NOW()),
(@reportTempId, 'TRANS_STATEMENT_DATE', 'Statement Date', '1', NOW()),
(@reportTempId, 'TRANS_DATE', 'Date', '1', NOW()),
(@reportTempId, 'TRANS_NUMBER', 'Number', '1', NOW()),
(@reportTempId, 'TRANS_DETAILS', 'Details', '1', NOW()),
(@reportTempId, 'TRANS_AMOUNT_PAID', 'Amount Paid', '1', NOW()),
(@reportTempId, 'TRANS_AMOUNT_DUE', 'Amount Due', '1', NOW()),
(@reportTempId, 'TRANS_TOTAL_AMOUNT_PAID', 'Total Amount Paid', '1', NOW()),
(@reportTempId, 'TRANS_TOTAL_AMOUNT_DUE', 'Total Amount Due', '1', NOW()),
(@reportTempId, 'TRANS_TOTAL_OUTSTANDING', 'Total Outstanding', '1', NOW()),
(@reportTempId, 'TRANS_BALANCE', 'Balance', '1', NOW()),
(@reportTempId, 'TRANS_ACCOUNT_NO', 'Account No.', '1', NOW());
END IF; 

END $$
CALL V20201231165104__Insert_UPNGStatementOfAcc() $$
DROP PROCEDURE IF EXISTS V20201231165104__Insert_UPNGStatementOfAcc $$
DELIMITER ;