DELIMITER $$
DROP PROCEDURE IF EXISTS V20210105112615__Create_ElectionVoterPoolCandidate $$
CREATE PROCEDURE V20210105112615__Create_ElectionVoterPoolCandidate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='election_voter_pool_candidate')) THEN 
CREATE TABLE `election_voter_pool_candidate` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `electionVoterPoolId` BIGINT(20) NOT NULL,
  `electionCandidateId` BIGINT(20) NOT NULL,
  `effectiveVote` INT NOT NULL,
  `votedOn` TIMESTAMP NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_election_voter_pool_candidate_1_idx` (`electionVoterPoolId` ASC),
  INDEX `fk_election_voter_pool_candidate_2_idx` (`electionCandidateId` ASC),
  INDEX `fk_election_voter_pool_candidate_3_idx` (`lastUpdatedBy` ASC),
  UNIQUE INDEX `electionVoterPoolId_UNIQUE` (`electionVoterPoolId` ASC, `electionCandidateId` ASC),
  CONSTRAINT `fk_election_voter_pool_candidate_1`
    FOREIGN KEY (`electionVoterPoolId`)
    REFERENCES `election_voter_pool` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_election_voter_pool_candidate_2`
    FOREIGN KEY (`electionCandidateId`)
    REFERENCES `election_candidate` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_election_voter_pool_candidate_3`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20210105112615__Create_ElectionVoterPoolCandidate () $$ 
DROP PROCEDURE IF EXISTS V20210105112615__Create_ElectionVoterPoolCandidate $$ 
DELIMITER ;