
DELIMITER $$

DROP PROCEDURE IF EXISTS V20210105234343__DFRAndTransforEnqReassignNotify $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210105234343__DFRAndTransforEnqReassignNotify()

BEGIN
 
  -- Insert new record in ui_translation table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM `form_field_info` WHERE formAliasName = 'enquiryreassignwindow' and formFieldId = 'sendReassignNotificationField' )) THEN
   
INSERT INTO `form_field_info` 
(`formAliasName`, `formFieldName`, `formFieldId`, `formFieldInputType`, `isMandatory`, `isLocked`, `lastUpdatedBy`, `lastUpdate`, `formFieldDefaultLabel`, `formScreenName`, `formScreenMode`, `fieldDisplayName`, `whetherForAllAcademyLocation`) 
VALUES ('enquiryreassignwindow', 'sendReassignNotification', 'sendReassignNotificationField', 'checkboxfield', 0, 0, 1, now(), 'Send reassign notification?', 'Reassign Enquiry', 'View', 'Send reassign notification?', 0);

END IF;

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='TRANSLATIONS' and keyName='SEND_REASSIGN_NOTIFICATION')) THEN
    
    INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`lastUpdate`,`lastUpdatedBy`) 
    VALUES ('TRANSLATIONS','SEND_REASSIGN_NOTIFICATION','Send reassign notification?','Send reassign notification?',now(),1);
 END IF;

END $$


-- Execute the stored procedure
CALL V20210105234343__DFRAndTransforEnqReassignNotify() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210105234343__DFRAndTransforEnqReassignNotify $$
 
DELIMITER ;
