DELIMITER $$

DROP PROCEDURE IF EXISTS V20210115183737__CreateTVETReportDownloadRequest $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210115183737__CreateTVETReportDownloadRequest()
BEGIN
  
  -- Add the email table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='tvet_report_download_request' )) THEN
    
	CREATE TABLE `tvet_report_download_request` (
	  `id` bigint NOT NULL AUTO_INCREMENT,
	  `requestBy` bigint DEFAULT NULL,
	  `requestTime` datetime DEFAULT NULL,
	  `noOfFiles` int DEFAULT NULL,
	  `requestStatus` varchar(45) DEFAULT NULL,
	  `errorMsg` text,
	  `fileLink` text,
	  `lastUpdate` timestamp NULL DEFAULT NULL,
	  `lastUpdatedBy` bigint DEFAULT NULL,
	  PRIMARY KEY (`id`),
	  KEY `fk_tvet_report_download_request_requestBy_idx` (`requestBy`),
	  KEY `fk_tvet_report_download_request_lastUpdatedBy_idx` (`lastUpdatedBy`),
	  CONSTRAINT `fk_tvet_report_download_request_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
	  CONSTRAINT `fk_tvet_report_download_request_requestBy` FOREIGN KEY (`requestBy`) REFERENCES `users` (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF ;
  
  IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='tvet_report_download_request_file' )) THEN

  CREATE TABLE `tvet_report_download_request_file` (
	  `id` bigint NOT NULL AUTO_INCREMENT,
	  `trdrId` bigint DEFAULT NULL,
	  `reportId` bigint DEFAULT NULL,
	  `noOfRecords` int DEFAULT NULL,
	  `isSuccess` bit(1) DEFAULT NULL,
	  `lastUpdate` timestamp NULL DEFAULT NULL,
	  `lastUpdatedBy` bigint DEFAULT NULL,
	  PRIMARY KEY (`id`),
	  KEY `fk_tvet_report_download_request_file_trdrId_idx` (`trdrId`),
	  KEY `fk_tvet_report_download_request_file_reportId_idx` (`reportId`),
	  KEY `fk_tvet_report_download_request_file_lastUpdatedBy_idx` (`lastUpdatedBy`),
	  CONSTRAINT `fk_tvet_report_download_request_file_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
	  CONSTRAINT `fk_tvet_report_download_request_file_reportId` FOREIGN KEY (`reportId`) REFERENCES `drop_down` (`id`),
	  CONSTRAINT `fk_tvet_report_download_request_file_trdrId` FOREIGN KEY (`trdrId`) REFERENCES `tvet_report_download_request` (`id`)
	) ENGINE=InnoDB DEFAULT CHARSET=utf8;

  END IF ;

END $$

-- Execute the stored procedure
CALL V20210115183737__CreateTVETReportDownloadRequest $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210115183737__CreateTVETReportDownloadRequest $$
 
DELIMITER ;
