DELIMITER $$
DROP PROCEDURE IF EXISTS V20210118125511__Insert_AdmissionDetailsDataGrid $$
CREATE PROCEDURE V20210118125511__Insert_AdmissionDetailsDataGrid()

BEGIN

	IF NOT EXISTS ((SELECT * FROM data_grid WHERE gridName="Academia.view.admission.applications.admissionAndMidTermAdmission.AdmissionProgramGrid" AND portalId=1)) THEN 
		INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
		('Academia.view.admission.applications.admissionAndMidTermAdmission.AdmissionProgramGrid',1,
		'[{"id":null,"columnName":"ADMISSION_ID","dataIndex":"admissionId","columnVisibility":"HIDE","sequence":1,"mandatory":false},
		{"id":null,"columnName":"ACADEMY_LOCATION","dataIndex":"academy","columnVisibility":"SHOW","sequence":2,"mandatory":true},
		{"id":null,"columnName":"PROGRAM","dataIndex":"program","columnVisibility":"SHOW","sequence":3,"mandatory":true},
		{"id":null,"columnName":"MODE_OF_DELIVERY","dataIndex":"modeOfDelivery","columnVisibility":"HIDE","sequence":4,"mandatory":false},
		{"id":null,"columnName":"REGISTRATION_TYPE","dataIndex":"batchPartTime","columnVisibility":"HIDE","sequence":5,"mandatory":false},
		{"id":null,"columnName":"BATCH","dataIndex":"batch","columnVisibility":"SHOW","sequence":6,"mandatory":true},
		{"id":null,"columnName":"SEAT_TYPE","dataIndex":"seatType","columnVisibility":"SHOW","sequence":7,"mandatory":false},
		{"id":null,"columnName":"ADMISSION_TYPE","dataIndex":"admissionType","columnVisibility":"SHOW","sequence":8,"mandatory":true},
		{"id":null,"columnName":"ADMISSION_STATUS_TYPE","dataIndex":"status","columnVisibility":"SHOW","sequence":9,"mandatory":true},
		{"id":null,"columnName":"ADMISSION_DATE_AD","dataIndex":"admissionDate","columnVisibility":"HIDE","sequence":10,"mandatory":false}]',now(),1);
	END IF; 

END $$

CALL V20210118125511__Insert_AdmissionDetailsDataGrid() $$
DROP PROCEDURE IF EXISTS V20210118125511__Insert_AdmissionDetailsDataGrid $$
DELIMITER ;
