DELIMITER $$
DROP PROCEDURE IF EXISTS V20210301125326__Create_VehicleFitnessCertificate $$
CREATE PROCEDURE V20210301125326__Create_VehicleFitnessCertificate()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='trans_vehicle_fitness_certificate')) THEN 
CREATE TABLE `trans_vehicle_fitness_certificate` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `vehicleId` BIGINT(20) NOT NULL,
  `issueDate` DATE NULL,
  `expiryDate` DATE NULL,
  `certifiedBy` VARCHAR(255) NULL,
  `documentId` BIGINT(20) DEFAULT NULL,  
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `trans_vfitnessc_vehicle_idx` (`vehicleId` ASC),
  INDEX `fk_vfitnessc_users_idx` (`lastUpdatedBy` ASC),
  INDEX `trans_vfitnessc_document_x` (`documentId` DESC),
  CONSTRAINT `trans_vfitnessc_vehicle_id`
    FOREIGN KEY (`vehicleId`)
    REFERENCES `trans_vehicle` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
CONSTRAINT `trans_vfitnessc_document_idx`
    FOREIGN KEY (`documentId`)
    REFERENCES `documents` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_vfitnessc_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210301125326__Create_VehicleFitnessCertificate () $$ 
DROP PROCEDURE IF EXISTS V20210301125326__Create_VehicleFitnessCertificate $$ 
DELIMITER ;