DELIMITER $$
DROP PROCEDURE IF EXISTS V20210511115937__Insert_HostelCheckOutConfigLoader $$
CREATE PROCEDURE V20210511115937__Insert_HostelCheckOutConfigLoader()
BEGIN

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Hostel Check-Out' and  code ='Bulk Hostel Check-Out')) THEN 
INSERT INTO `import_utility_master` (`screenName`, `fileDirectory`, `code`, `lastUpdatedBy`)
 VALUES ('Bulk Hostel Check-Out', 'hostel/CheckOut', 'Bulk Hostel Check-Out', '1');
END IF; 

SET @importMasterId=(select id from import_utility_master where code = 'Bulk Hostel Check-Out' );

	
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'HOSTEL_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'HOSTEL_HEADER' , 'Hostel' , 0,  sysdate()  , 1 , 'Hostel' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BUILDING_HEADER' and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BUILDING_HEADER' , 'Building' , 0,  sysdate()  , 1 , 'Building' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'FLOOR_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'FLOOR_HEADER' , 'Floor' , 0,  sysdate()  , 1 , 'Floor' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ROOM_HEADER' and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ROOM_HEADER' , 'Room' , 0,  sysdate()  , 1 , 'Room' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ROOM_TYPE_HEADER' and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ROOM_TYPE_HEADER' , 'Room Type' , 0,  sysdate()  , 1 , 'Room Type' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'USER_TYPE_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'USER_TYPE_HEADER' , 'UserType' , 0,  sysdate()  , 1 , 'UserType' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'STUDENT_ID_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'STUDENT_ID_HEADER' , 'StudentID/UserID' , 0,  sysdate()  , 1 , 'StudentID/UserID' , 1, 1, ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'NAME_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'NAME_HEADER' , 'Name' , 0,  sysdate()  , 1 , 'Name' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ALLOTMENT_STATUS_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ALLOTMENT_STATUS_HEADER' , 'Allotment Status' , 0,  sysdate()  , 1 , 'Allotment Status' , 1, 1, ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BED_NO_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BED_NO_HEADER' , 'Bed No.' , 0,  sysdate()  , 1 , 'Bed No.' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CHECK-INDATE_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CHECK-INDATE_HEADER' , 'Checked-In Date' , 0,  sysdate()  , 1 , 'Checked-In Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'KEY_RETUREND_TO_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'KEY_RETUREND_TO_HEADER' , 'Key Returend To' , 0,  sysdate()  , 1 , 'Key Returend To' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CHECK_OUT_DATE_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CHECK_OUT_DATE_HEADER' , 'Checked-Out Date' , 0,  sysdate()  , 1 , 'Checked-Out Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CHECKED_OUT_REASON_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CHECKED_OUT_REASON_HEADER' , 'Checked Out Reason' , 0,  sysdate()  , 1 , 'Checked Out Reason' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SERVICE_OPT_OUT_REQUIRED_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SERVICE_OPT_OUT_REQUIRED_HEADER' , 'Service Opt out Required' , 0,  sysdate()  , 1 , 'Service Opt out Required' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;

	
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'HOSTEL_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'HOSTEL_HEADER' , 'Hostel' , 1,  sysdate()  , 1 , 'Hostel' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BUILDING_HEADER' and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BUILDING_HEADER' , 'Building' , 1,  sysdate()  , 1 , 'Building' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'FLOOR_HEADER'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'FLOOR_HEADER' , 'Floor' , 1,  sysdate()  , 1 , 'Floor' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ROOM_HEADER' and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ROOM_HEADER' , 'Room' , 1,  sysdate()  , 1 , 'Room' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ROOM_TYPE_HEADER' and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ROOM_TYPE_HEADER' , 'Room Type' , 1,  sysdate()  , 1 , 'Room Type' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'USER_TYPE_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'USER_TYPE_HEADER' , 'UserType' , 1,  sysdate()  , 1 , 'UserType' , 1, 1, ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'STUDENT_ID_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'STUDENT_ID_HEADER' , 'StudentID/UserID' , 1,  sysdate()  , 1 , 'StudentID/UserID' , 1, 1, ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'NAME_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'NAME_HEADER' , 'Name' , 1,  sysdate()  , 1 , 'Name' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'ALLOTMENT_STATUS_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'ALLOTMENT_STATUS_HEADER' , 'Allotment Status' , 1,  sysdate()  , 1 , 'Allotment Status' , 1, 1, ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'BED_NO_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'BED_NO_HEADER' , 'Bed No.' , 1,  sysdate()  , 1 , 'Bed No.' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CHECK-INDATE_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CHECK-INDATE_HEADER' , 'Checked-In Date' , 1,  sysdate()  , 1 , 'Checked-In Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'KEY_RETUREND_TO_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'KEY_RETUREND_TO_HEADER' , 'Key Returend To' , 1,  sysdate()  , 1 , 'Key Returend To' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CHECK_OUT_DATE_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CHECK_OUT_DATE_HEADER' , 'Checked-Out Date' , 1,  sysdate()  , 1 , 'Checked-Out Date' , 1, 1 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'CHECKED_OUT_REASON_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'CHECKED_OUT_REASON_HEADER' , 'Checked Out Reason' , 1,  sysdate()  , 1 , 'Checked Out Reason' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'SERVICE_OPT_OUT_REQUIRED_HEADER' and importUtilityMasterId=@importMasterId  and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`importUtilityMasterId`) 
VALUES (  'SERVICE_OPT_OUT_REQUIRED_HEADER' , 'Service Opt out Required' , 1,  sysdate()  , 1 , 'Service Opt out Required' , 0, 0 , ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) ); 
END IF;


IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'HOSTEL_ALLOTMENT_ID'  and importUtilityMasterId=@importMasterId and isSchool = 0)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`isVisible`,`importUtilityMasterId`) 
VALUES (  'HOSTEL_ALLOTMENT_ID' , 'id' , 0,  sysdate()  , 1 , 'id' , 1, 0 , 0,( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;


	
IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE headerCode = 'HOSTEL_ALLOTMENT_ID'  and importUtilityMasterId=@importMasterId and isSchool = 1)) THEN
INSERT INTO `loader_header` ( `headerCode`, `headerLabel`,  `isSchool`, `lastUpdate`, `lastUpdatedBy`, `defaultHeaderLabel`,`isNonEditable`,`isMandatory`,`isVisible`,`importUtilityMasterId`) 
VALUES (  'HOSTEL_ALLOTMENT_ID' , 'id' , 1,  sysdate()  , 1 , 'id' , 1, 0 ,0, ( select id from import_utility_master where code = 'Bulk Hostel Check-Out' ) );
END IF;
END $$
CALL V20210511115937__Insert_HostelCheckOutConfigLoader() $$
DROP PROCEDURE IF EXISTS V20210511115937__Insert_HostelCheckOutConfigLoader $$
DELIMITER ;