DELIMITER $$
DROP PROCEDURE IF EXISTS V20210702155725__CreateNSFASProvisionalFundEFC $$
CREATE PROCEDURE V20210702155725__CreateNSFASProvisionalFundEFC()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='nsfas_provisional_fund_efc')) THEN 
CREATE TABLE `nsfas_provisional_fund_efc` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `currency_code` varchar(50) DEFAULT NULL,
  `decimal_place` varchar(10) DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `nsfas_person_provisional_fund_id` bigint DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_nsfas_provisional_fund_efc_id_idx` (`lastUpdatedBy`),
  KEY `fk_nsfas_fund_efc_person_provisional_fund_id_idx` (`nsfas_person_provisional_fund_id`),
  CONSTRAINT `fk_nsfas_fund_efc_provisional_fund_id` FOREIGN KEY (`nsfas_person_provisional_fund_id`) REFERENCES `nsfas_person_provisional_fund` (`id`),
  CONSTRAINT `fk_nsfas_provisional_fund_efc_lastUpdatedBy_id` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
  ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


END IF; 

END $$
CALL V20210702155725__CreateNSFASProvisionalFundEFC () $$ 
DROP PROCEDURE IF EXISTS V20210702155725__CreateNSFASProvisionalFundEFC $$ 
DELIMITER ;