DELIMITER $$
DROP PROCEDURE IF EXISTS V20210708153830__Create_FBC_manage_target_analytics $$
CREATE PROCEDURE V20210708153830__Create_FBC_manage_target_analytics()
BEGIN

DROP VIEW IF EXISTS fbc_manage_target_analytics;

IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='fbc_manage_target_analytics')) THEN 

CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `powerbi`@`%` 
    SQL SECURITY DEFINER
VIEW `fbc_manage_target_analytics` AS
    SELECT DISTINCT
        `mt`.`academyLocationId` AS `academyLocationId`,
        `al`.`academyCode` AS `academyCode`,
        `al`.`academyName` AS `academyName`,
        `al`.`displayName` AS `displayName`,
        `al`.`locationCode` AS `locationCode`,
        `al`.`locationName` AS `locationName`,
        `progroup`.`groupName` AS `Program_Group`,
        `prog`.`programCode` AS `programCode`,
        `prog`.`programName` AS `programName`,
        `prog`.`programShortName` AS `programShortName`,
        `btc`.`batchName` AS `batchName`,
        `iy`.`itemValue` AS `Intake_Year`,
        `mod`.`itemValue` AS `ModeOfDelivery`,
        `pbpc`.`programPeriodName` AS `PeriodName`,
        `pbpc`.`printName` AS `PeriodprintName`,
        `at`.`itemValue` AS `AcademicTerm`,
        `mt`.`enquiryTarget` AS `enquiryTarget`,
        `mt`.`applicationTarget` AS `applicationTarget`,
        `mt`.`enrolmentPreviousYear` AS `enrolmentPreviousYear`,
        `mt`.`enrolmentTarget` AS `enrolmentTarget`,
        `mt`.`enrolmentBudget` AS `enrolmentBudget`,
        `mt`.`revisedBudget` AS `revisedBudget`,
        `mt`.`buildingCapacity` AS `buildingCapacity`,
        `mt`.`buildingCapacitySpecialist` AS `buildingCapacitySpecialist`,
        `mt`.`returningStudents` AS `returningStudents`
    FROM
        ((((((((`manage_target` `mt`
        LEFT JOIN `academy_location` `al` ON ((`al`.`id` = `mt`.`academyLocationId`)))
        LEFT JOIN `programs` `prog` ON ((`prog`.`id` = `mt`.`programId`)))
        LEFT JOIN `program_group` `progroup` ON ((`progroup`.`id` = `mt`.`programGroupId`)))
        LEFT JOIN `batches` `btc` ON ((`btc`.`id` = `mt`.`batchId`)))
        LEFT JOIN `mode_of_delivery` `mod` ON ((`mod`.`id` = `btc`.`modeOfDeliveryId`)))
        LEFT JOIN `prog_batch_period_config` `pbpc` ON (((`btc`.`id` = `pbpc`.`programBatchId`)
            AND (`pbpc`.`whetherPlacementPeriod` = 0))))
        LEFT JOIN `academic_term` `at` ON ((`at`.`id` = `pbpc`.`academicTermId`)))
        LEFT JOIN `intake_year` `iy` ON ((`iy`.`id` = `mt`.`intakeYearId`)));

END IF; 

END $$
CALL V20210708153830__Create_FBC_manage_target_analytics () $$ 
DROP PROCEDURE IF EXISTS V20210708153830__Create_FBC_manage_target_analytics $$ 
DELIMITER ;