DELIMITER $$
DROP PROCEDURE IF EXISTS V20210809140344__Create_TermWiseRegistrationContract $$
CREATE PROCEDURE V20210809140344__Create_TermWiseRegistrationContract()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='term_wise_registration_contract')) THEN 
CREATE TABLE `term_wise_registration_contract` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `registrationTermSetupDetailId` bigint(20) NOT NULL,
  `documentId` bigint(20) DEFAULT NULL,
  `whetherRegistrationContractApplicable` BIT(1) NOT NULL DEFAULT b'0',
  `registrationContractMsgContent` varchar(5000) DEFAULT NULL ,
  `lastUpdatedBy` bigint(20) NOT NULL,
  `lastUpdate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `fk_term_wise_registration_contract_1_idx` (`registrationTermSetupDetailId`),
  KEY `fk_term_wise_registration_contract_2_idx` (`documentId`),
  KEY `fk_term_wise_registration_contract_3_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_term_wise_registration_contract_1` FOREIGN KEY (`registrationTermSetupDetailId`) REFERENCES `registration_term_setup_detail` (`id`),
  CONSTRAINT `fk_term_wise_registration_contract_2` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`),
  CONSTRAINT `fk_term_wise_registration_contract_3` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20210809140344__Create_TermWiseRegistrationContract () $$ 
DROP PROCEDURE IF EXISTS V20210809140344__Create_TermWiseRegistrationContract $$ 
DELIMITER ;