DELIMITER $$
DROP PROCEDURE IF EXISTS V20210812134940__UpdateDataGridNSFASDetails $$
CREATE PROCEDURE V20210812134940__UpdateDataGridNSFASDetails()
BEGIN
SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.NSFAS.BursaryApplicationDetails' AND portalId=1)) THEN 
UPDATE `data_grid` SET jsonObject =
'[{
	"id": null,
	"columnName": "NATIONAL_ID",
	"dataIndex": "identification",
	"columnVisibility": "SHOW",
	"sequence": 1,
	"mandatory": false
}, {
	"id": null,
	"columnName": "STUDENT_NAME",
	"dataIndex": "name",
	"columnVisibility": "SHOW",
	"sequence": 2,
	"mandatory": false
}, {
	"id": null,
	"columnName": "TELEPHONE",
	"dataIndex": "phoneNumber",
	"columnVisibility": "SHOW",
	"sequence": 3,
	"mandatory": false
}, {
	"id": null,
	"columnName": "ADDRESS_LINE",
	"dataIndex": "addressLine",
	"columnVisibility": "SHOW",
	"sequence": 4,
	"mandatory": false
}, {
	"id": null,
	"columnName": "CITY",
	"dataIndex": "city",
	"columnVisibility": "SHOW",
	"sequence": 5,
	"mandatory": false
}, {
	"id": null,
	"columnName": "APPLICATION_DATE",
	"dataIndex": "applicationDate",
	"columnVisibility": "SHOW",
	"sequence": 6,
	"mandatory": false
}, {
	"id": null,
	"columnName": "CYCLE",
	"dataIndex": "processCycle",
	"columnVisibility": "SHOW",
	"sequence": 7,
	"mandatory": false
}, {
	"id": null,
	"columnName": "LEVEL_OF_STUDY",
	"dataIndex": "levelOfStudy",
	"columnVisibility": "SHOW",
	"sequence": 8,
	"mandatory": false
}, {
	"id": null,
	"columnName": "CAMPUS",
	"dataIndex": "campus",
	"columnVisibility": "SHOW",
	"sequence": 9,
	"mandatory": false
}, {
	"id": null,
	"columnName": "ACCOMODATION",
	"dataIndex": "accomodation",
	"columnVisibility": "SHOW",
	"sequence": 10,
	"mandatory": false
}, {
	"id": null,
	"columnName": "TRAVEL",
	"dataIndex": "travel",
	"columnVisibility": "SHOW",
	"sequence": 11,
	"mandatory": false
}, {
	"id": null,
	"columnName": "MEALS",
	"dataIndex": "meals",
	"columnVisibility": "SHOW",
	"sequence": 12,
	"mandatory": false
}, {
	"id": null,
	"columnName": "CODE",
	"dataIndex": "progCode",
	"columnVisibility": "HIDE",
	"sequence": 13,
	"mandatory": false
}, {
	"id": null,
	"columnName": "NAME",
	"dataIndex": "progName",
	"columnVisibility": "SHOW",
	"sequence": 14,
	"mandatory": false
}, {
	"id": null,
	"columnName": "PREFERRED",
	"dataIndex": "isPreffered",
	"columnVisibility": "HIDE",
	"sequence": 15,
	"mandatory": false
}, {
	"id": null,
	"columnName": "STATUS",
	"dataIndex": "status",
	"columnVisibility": "SHOW",
	"sequence": 16,
	"mandatory": false
}, {
	"id": null,
	"columnName": "LM_UPDATED_ON",
	"dataIndex": "lastUpdate",
	"columnVisibility": "SHOW",
	"sequence": 17,
	"mandatory": false
}]'
where gridName='Academia.view.personinfo.common.NSFAS.BursaryApplicationDetails' AND portalId=1;

END IF; 


IF EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.NSFAS.BursaryFunddingDetails' AND portalId=1)) THEN 
UPDATE `data_grid` SET jsonObject =
'[{
	"id": null,
	"columnName": "LM_UPDATED_ON",
	"dataIndex": "updateOn",
	"columnVisibility": "SHOW",
	"sequence": 1,
	"mandatory": false
}, {
	"id": null,
	"columnName": "CYCLE",
	"dataIndex": "cycle",
	"columnVisibility": "SHOW",
	"sequence": 2,
	"mandatory": false
}, {
	"id": null,
	"columnName": "STUDENT_NAME",
	"dataIndex": "givenName",
	"columnVisibility": "SHOW",
	"sequence": 3,
	"mandatory": false
}, {
	"id": null,
	"columnName": "NATIONAL_ID",
	"dataIndex": "identification",
	"columnVisibility": "SHOW",
	"sequence": 4,
	"mandatory": false
}, {
	"id": null,
	"columnName": "IDENTIFICATION_TYPE",
	"dataIndex": "identificationType",
	"columnVisibility": "HIDE",
	"sequence": 5,
	"mandatory": false
}, {
	"id": null,
	"columnName": "REFERENCE_NO",
	"dataIndex": "applicationRefNo",
	"columnVisibility": "SHOW",
	"sequence": 6,
	"mandatory": false
}, {
	"id": null,
	"columnName": "APPLICANT_INDICATOR",
	"dataIndex": "isApplicantIndicator",
	"columnVisibility": "SHOW",
	"sequence": 7,
	"mandatory": false
}, {
	"id": null,
	"columnName": "RETURNING_STUDENT",
	"dataIndex": "isReturningStudentIndicator",
	"columnVisibility": "SHOW",
	"sequence": 8,
	"mandatory": false
}, {
	"id": null,
	"columnName": "FUNDDING_YEAR",
	"dataIndex": "fundingYear",
	"columnVisibility": "SHOW",
	"sequence": 9,
	"mandatory": false
}, {
	"id": null,
	"columnName": "FUNDER",
	"dataIndex": "funder",
	"columnVisibility": "SHOW",
	"sequence": 10,
	"mandatory": false
}, {
	"id": null,
	"columnName": "CAP_TYPE",
	"dataIndex": "capType",
	"columnVisibility": "SHOW",
	"sequence": 11,
	"mandatory": false
}, {
	"id": null,
	"columnName": "CURRENCY_CODE",
	"dataIndex": "currencyCode",
	"columnVisibility": "SHOW",
	"sequence": 12,
	"mandatory": false
}, {
	"id": null,
	"columnName": "DECIMAL_PLACES",
	"dataIndex": "decimalPlace",
	"columnVisibility": "SHOW",
	"sequence": 13,
	"mandatory": false
}, {
	"id": null,
	"columnName": "AMOUNT",
	"dataIndex": "amount",
	"columnVisibility": "SHOW",
	"sequence": 14,
	"mandatory": false
}]'
where gridName='Academia.view.personinfo.common.NSFAS.BursaryFunddingDetails' AND portalId=1;

END IF;



IF EXISTS ((select * from data_grid where gridName='Academia.view.personinfo.common.NSFAS.BursaryApplicationStatus' AND portalId=1)) THEN 
UPDATE `data_grid` SET jsonObject =
'[{
 	"id": null,
 	"columnName": "NATIONAL_ID",
 	"dataIndex": "identification",
 	"columnVisibility": "SHOW",
 	"sequence": 1,
 	"mandatory": false
 }, {
	"id": null,
	"columnName": "IDENTIFICATION_TYPE",
	"dataIndex": "identificationType",
	"columnVisibility": "SHOW",
	"sequence": 2,
	"mandatory": false
},{
 	"id": null,
 	"columnName": "STUDENT_NAME",
 	"dataIndex": "name",
 	"columnVisibility": "SHOW",
 	"sequence": 3,
 	"mandatory": false
 }, {
 	"id": null,
 	"columnName": "CYCLE",
 	"dataIndex": "processCycle",
 	"columnVisibility": "SHOW",
 	"sequence": 4,
 	"mandatory": false
 }, {
 	"id": null,
 	"columnName": "STATUS1",
 	"dataIndex": "status",
 	"columnVisibility": "SHOW",
 	"sequence": 5,
 	"mandatory": false
 }, {
 	"id": null,
 	"columnName": "STATUS2",
 	"dataIndex": "statusTwo",
 	"columnVisibility": "SHOW",
 	"sequence": 6,
 	"mandatory": false
 }, {
 	"id": null,
 	"columnName": "LM_UPDATED_ON",
 	"dataIndex": "lastUpdate",
 	"columnVisibility": "SHOW",
 	"sequence": 7,
 	"mandatory": false
 }]'
where gridName='Academia.view.personinfo.common.NSFAS.BursaryApplicationStatus' AND portalId=1;

END IF;

SET SQL_SAFE_UPDATES=1;
END $$
CALL V20210812134940__UpdateDataGridNSFASDetails () $$
DROP PROCEDURE IF EXISTS V20210812134940__UpdateDataGridNSFASDetails $$
DELIMITER ;