DELIMITER $$
DROP PROCEDURE IF EXISTS V20210830140401__Alter_PKA_FeePlanRule_PaymentG $$
CREATE PROCEDURE V20210830140401__Alter_PKA_FeePlanRule_PaymentG()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='fee_plan_rules' AND column_name in('paymentGroupId','paymentTermId'))) THEN 
ALTER TABLE `fee_plan_rules` 
ADD COLUMN `paymentGroupId` BIGINT NULL DEFAULT NULL AFTER `allowPartialPaymentMobileApp`,
ADD COLUMN `paymentTermId` BIGINT NULL DEFAULT NULL AFTER `paymentGroupId`,
ADD INDEX `ek_fee_plan_rule_paymentGroup_idx` (`paymentGroupId` ASC) ,
ADD INDEX `fk_fee_plan_rule_paymentTerm_idx` (`paymentTermId` ASC) ;

ALTER TABLE `fee_plan_rules` 
ADD CONSTRAINT `fk_fee_plan_rule_paymentGroup`
  FOREIGN KEY (`paymentGroupId`)
  REFERENCES `payment_group` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_fee_plan_rule_paymentTerm`
  FOREIGN KEY (`paymentTermId`)
  REFERENCES `payment_term` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF; 

END $$
CALL V20210830140401__Alter_PKA_FeePlanRule_PaymentG() $$
DROP PROCEDURE IF EXISTS V20210830140401__Alter_PKA_FeePlanRule_PaymentG $$
DELIMITER ;