DELIMITER $$
DROP PROCEDURE IF EXISTS V20211222141356__Create_socio_economic_detail_view $$
CREATE PROCEDURE V20211222141356__Create_socio_economic_detail_view()
BEGIN
DROP VIEW IF EXISTS socio_economic_detail_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='socio_economic_detail_view')) THEN 
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `socio_economic_detail_view` AS
    SELECT DISTINCT
        `ap`.`externalSysRefOne` AS `sunumber`,
        `app`.`code` AS `application_code`,
        `app`.`applicantPersonId` AS `applicantPersonId`,
        `ddp1`.`name` AS `parent_qualification1`,
        `ddp1`.`value` AS `parent_qualification1_Display`,
        `ddp2`.`name` AS `parent_qualification2`,
        `ddp2`.`value` AS `parent_qualification2_Display`,
        `ei`.`received_child_benefit` AS `childAllowance`,
        `ei`.`social_pension` AS `statePension`,
        `ddsb`.`name` AS `schoolFeesBursary`,
        `ddsb`.`value` AS `schoolFeesBursary_Display`,
        `ddps`.`name` AS `pay_study`,
        `ddps`.`value` AS `pay_study_Display`,
        `ddpig`.`name` AS `parentIncomGroup`,
        `ddpig`.`value` AS `parentIncomGroup_Display`,
        `ei`.`parent_occupation` AS `parent_occupation`,
        `ei`.`employer` AS `employer`,
        `ddfs`.`name` AS `FinancialSupport`,
        `ddfs`.`value` AS `FinancialSupport_Display`
    FROM
        ((((((((`application` `app`
        LEFT JOIN `applicant_person` `ap` ON ((`app`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `economic_information` `ei` ON ((`ei`.`applicant_person_id` = `ap`.`id`)))
        LEFT JOIN `drop_down` `ddp1` ON ((`ddp1`.`id` = `ei`.`parent_qualification1`)))
        LEFT JOIN `drop_down` `ddp2` ON ((`ddp2`.`id` = `ei`.`parent_qualification2`)))
        LEFT JOIN `drop_down` `ddsb` ON ((`ddsb`.`id` = `ei`.`is_scholarship`)))
        LEFT JOIN `drop_down` `ddps` ON ((`ddps`.`id` = `ei`.`pay_study`)))
        LEFT JOIN `drop_down` `ddpig` ON ((`ddpig`.`id` = `ei`.`parent_annual_income`)))
        LEFT JOIN `drop_down` `ddfs` ON ((`ddfs`.`id` = `ei`.`school_fee_per_year`)));

END IF; 

END $$
CALL V20211222141356__Create_socio_economic_detail_view () $$ 
DROP PROCEDURE IF EXISTS V20211222141356__Create_socio_economic_detail_view $$ 
DELIMITER ;