DELIMITER $$
DROP PROCEDURE IF EXISTS V20220302100720__Insert_reportTemplate $$
CREATE PROCEDURE V20220302100720__Insert_reportTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'GRADE_AVERAGE_REPORT_COMPONENT_LEVEL')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'GRADE_AVERAGE_REPORT_COMPONENT_LEVEL', 'Grade average report component level', 'GRADE_AVERAGE_REPORT_COMPONENT_LEVEL.png', 'CommonReport_Excel.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'GRADE_AVERAGE_REPORT_COMPONENT_LEVEL.jasper', 'AcademiaLogo.png');
END IF; 

set @tempKey = (select id from report_template where templateCode ='GRADE_AVERAGE_REPORT_COMPONENT_LEVEL');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_STUDENT_ID')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_STUDENT_ID', 'Student ID', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_STUDENT_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_STUDENT_NAME', 'Student Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_ASSESSMENT_LEVEL_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_ASSESSMENT_LEVEL_NAME', 'Assessment Level Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_COURSE_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_COURSE_NAME', 'Course Name', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_STUDENT_AVERAGE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_STUDENT_AVERAGE', 'Student Average', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_STUDENT_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_STUDENT_MARKS', 'Student Marks', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_GRADE_AVERAGE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_GRADE_AVERAGE', 'Grade Average', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_PROMOTION_RESULT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_PROMOTION_RESULT', 'Promotion Result', '1', now());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @tempKey and keyValue='TRANS_OVERALL_MARKS')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@tempKey, 'TRANS_OVERALL_MARKS', 'Overall Mark', '1', now());
END IF;

END $$
CALL V20220302100720__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20220302100720__Insert_reportTemplate $$
DELIMITER ;