DELIMITER $$
DROP PROCEDURE IF EXISTS V20220915115603__Create_StudentMOUTable $$
CREATE PROCEDURE V20220915115603__Create_StudentMOUTable()
BEGIN


IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='student_MOU')) THEN 
CREATE TABLE `student_MOU`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint NOT NULL,
`effectiveStartDate` date NOT NULL,
`auditDate` date DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_studentMOU_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_studentMOU_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_studentMOU_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20220915115603__Create_StudentMOUTable () $$ 
DROP PROCEDURE IF EXISTS V20220915115603__Create_StudentMOUTable $$ 
DELIMITER ;